% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_matrices.R
\name{incidence_matrix}
\alias{incidence_matrix}
\title{Find the Incidence Matrix of a Hypergraph}
\usage{
incidence_matrix(hype, augment_oriented = TRUE)
}
\arguments{
\item{hype}{A hypergraph object}

\item{augment_oriented}{Whether to augment an oriented hypergraph}
}
\value{
An incidence matrix or a list of two incidence matrices.
}
\description{
An incidence matrix has rows indexed by vertices and columns indexed by
hyperedges. Each entry is non-zero if the associated vertex is a member of
the associated hyperedge. For an oriented hypergraph, this returns a list of
two matrices with the first representing incidence to one end of the
hyperedges and the second representing incidence to the other end. For a
directed hypergraph the first represents incidence to the tail of a
hyperedge and the second represents incidence to the head.
}
\details{
It is hard to use the incidence matrices of oriented undirected hypergraphs
in calculations. The \code{augment_oriented} option turns the hypergraph into a
directed hypergraph, but each hyperedge is represented twice, once pointing
in each direction. This is much easier to use for further calculations.
}
\examples{
h1 <- example_hype()
incidence_matrix(h1)

h2 <- example_hype(oriented = TRUE, directed = TRUE)
incidence_matrix(h2)
}
