% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{lint_js}
\alias{lint_js}
\title{Lint JavaScript}
\usage{
lint_js(fix = FALSE)
}
\arguments{
\item{fix}{Automatically fix problems.}
}
\value{
None. This function is called for side effects.
}
\description{
Runs \href{https://eslint.org}{ESLint} on the JavaScript sources in the \code{app/js} directory.
Requires Node.js and the \code{yarn} command to be available on the system.
}
\details{
If your JS code uses global objects defined by other JS libraries or R packages,
you'll need to let the linter know or it will complain about undefined objects.
For example, the \code{{leaflet}} package defines a global object \code{L}.
To access it without raising linter errors, add \verb{/* global L */} comment in your JS code.

You don't need to define \code{Shiny} and \code{$} as these global variables are defined by default.

If you find a particular ESLint error inapplicable to your code,
you can disable a specific rule for the next line of code with a comment like:

\if{html}{\out{<div class="sourceCode js">}}\preformatted{// eslint-disable-next-line no-restricted-syntax
}\if{html}{\out{</div>}}

See the \href{https://eslint.org/docs/user-guide/configuring/rules#using-configuration-comments-1}{ESLint documentation}
for full details.
}
\examples{
if (interactive()) {
  # Lint the JavaScript sources in the `app/js` directory.
  lint_js()
}
}
