\name{multiNicheGeneticProgramming}
\alias{multiNicheGeneticProgramming}
\title{Cluster-based multi-niche genetic programming}
\usage{
  multiNicheGeneticProgramming(fitnessFunction,
    stopCondition = makeTimeStopCondition(25),
    passStopCondition = makeTimeStopCondition(5),
    numberOfNiches = 2,
    clusterFunction = groupListConsecutive,
    joinFunction = function(niches) Reduce(c, niches),
    population = NULL, populationSize = 100,
    eliteSize = ceiling(0.1 * populationSize),
    elite = list(), functionSet = mathFunctionSet,
    inputVariables = inputVariableSet("x"),
    constantSet = numericConstantSet,
    crossoverFunction = crossover, mutationFunction = NULL,
    restartCondition = makeEmptyRestartCondition(),
    restartStrategy = makeLocalRestartStrategy(),
    searchHeuristic = makeAgeFitnessComplexityParetoGpSearchHeuristic(),
    progressMonitor = NULL, verbose = TRUE,
    clusterApply = sfClusterApplyLB,
    clusterExport = sfExport)
}
\arguments{
  \item{fitnessFunction}{In case of a single-objective
  selection function, \code{fitnessFunction} must be a
  single function that assigns a numerical fitness value to
  a GP individual represented as a R function.  Smaller
  fitness values mean higher/better fitness. If a
  multi-objective selection function is used,
  \code{fitnessFunction} must return a numerical vector of
  fitness values.}

  \item{stopCondition}{The stop condition for the evolution
  main loop. See \code{makeStepsStopCondition} for
  details.}

  \item{passStopCondition}{The stop condition for each
  parallel pass. See \code{makeStepsStopCondition} for
  details.}

  \item{numberOfNiches}{The number of niches to cluster the
  population into.}

  \item{clusterFunction}{The function used to cluster the
  population into niches. The first parameter of this
  function is a GP population, the second paramater an
  integer representing the number of niches. Defaults to
  \code{\link{groupListConsecutive}}.}

  \item{joinFunction}{The function used to join all niches
  into a population again after a round of parallel passes.
  Defaults to a function that simply concatenates all
  niches.}

  \item{population}{The GP population to start the run
  with. If this parameter is missing, a new GP population
  of size \code{populationSize} is created through random
  growth.}

  \item{populationSize}{The number of individuals if a
  population is to be created.}

  \item{eliteSize}{The number of "elite" individuals to
  keep. Defaults to \code{ceiling(0.1 * populationSize)}.}

  \item{elite}{The elite list, must be alist of individuals
  sorted in ascending order by their first fitness
  component.}

  \item{functionSet}{The function set.}

  \item{inputVariables}{The input variable set.}

  \item{constantSet}{The set of constant factory
  functions.}

  \item{searchHeuristic}{The search-heuristic (i.e.
  optimization algorithm) to use in the search of
  solutions. See the documentation for
  \code{searchHeuristics} for available algorithms.}

  \item{crossoverFunction}{The crossover function.}

  \item{mutationFunction}{The mutation function.}

  \item{restartCondition}{The restart condition for the
  evolution main loop. See
  \link{makeFitnessStagnationRestartCondition} for
  details.}

  \item{restartStrategy}{The strategy for doing restarts.
  See \link{makeLocalRestartStrategy} for details.}

  \item{progressMonitor}{A function of signature
  \code{function(population, fitnessValues,
  fitnessFunction, stepNumber, evaluationNumber,
  bestFitness, timeElapsed)} to be called with each
  evolution step.}

  \item{verbose}{Whether to print progress messages.}

  \item{clusterApply}{The cluster apply function that is
  used to distribute the parallel passes to CPUs in a
  compute cluster.}

  \item{clusterExport}{A function that is used to export R
  variables to the nodes of a CPU cluster, defaults to
  \code{sfExport}.}
}
\value{
  A genetic programming result object that contains a GP
  population in the field \code{population}, as well as
  metadata describing the run parameters.
}
\description{
  Perform a multi-niche genetic programming run. The
  required argument \code{fitnessFunction} must be supplied
  with an objective function that assigns a numerical
  fitness value to an R function. Fitness values are
  minimized, i.e. smaller values mean higher/better
  fitness. If a multi-objective \code{selectionFunction} is
  used, \code{fitnessFunction} return a numerical vector of
  fitness values. In a multi-niche genetic programming run,
  the initial population is clustered via a
  \code{clusterFunction} into \code{numberOfNiches} niches.
  In each niche, a genetic programming run is executed with
  \code{passStopCondition} as stop condition. These runs
  are referred to as a parallel pass. After each parallel
  pass, the niches are joined again using a
  \code{joinFunction} into a population. From here, the
  process starts again with a clustering step, until the
  global \code{stopCondition} is met. The result of the
  multi-niche genetic programming run is a genetic
  programming result object containing a GP population of R
  functions. \code{summary.geneticProgrammingResult} can be
  used to create summary views of a GP result object.
}
\seealso{
  \code{\link{geneticProgramming}},
  \code{\link{summary.geneticProgrammingResult}},
  \code{\link{symbolicRegression}}
}

