% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gads_get_report.R
\name{gads_get_report}
\alias{gads_get_report}
\title{Get data from Google Ads API}
\usage{
gads_get_report(
  resource = "campaign",
  fields = c("campaign.id", "campaign.name", "customer.id",
    "customer.descriptive_name", "campaign.status", "segments.date",
    "metrics.all_conversions", "metrics.clicks", "metrics.cost_micros", "metrics.ctr",
    "metrics.impressions", "metrics.interaction_rate", "metrics.interactions",
    "metrics.invalid_clicks"),
  where = NULL,
  order_by = NULL,
  limit = NULL,
  parameters = NULL,
  date_from = Sys.Date() - 15,
  date_to = Sys.Date() - 1,
  customer_id = getOption("gads.customer.id"),
  login_customer_id = getOption("gads.login.customer.id"),
  include_resource_name = FALSE,
  cl = NULL,
  verbose = TRUE
)
}
\arguments{
\item{resource}{Report type, for more information see \href{https://developers.google.com/google-ads/api/fields/v8/overview#list-of-all-resources}{link with list of all resources}}

\item{fields}{character vector, list of report fields, all report has own fields list, for example \href{https://developers.google.com/google-ads/api/fields/v8/campaign}{see field list of campaign report}.}

\item{where}{Filter, for example you can filter campaigns by status \code{where = "campaign.status = 'ENABLED'"}.}

\item{order_by}{Sorting, character vectors of fields and sorting directions, for example \code{order_by = c("campaign.name DESC", "metrics.clicks")}.}

\item{limit}{Maximun rows in report}

\item{parameters}{Query parameters, for example \code{parameters = "include_drafts=true"}.}

\item{date_from}{Beginning of date range. Format: 2018-01-01}

\item{date_to}{End of date rage. Format: 2018-01-10}

\item{customer_id}{Google Ads client customer id, supports a single account id: "xxx-xxx-xxxx" or a vector of ids from the same Google Ads MCC: c("xxx-xxx-xxxx", "xxx-xxx-xxxx")}

\item{login_customer_id}{Google Ads manager customer id}

\item{include_resource_name}{Get resource names fields in report}

\item{cl}{A cluster object created by \code{\link{makeCluster}}, or an integer to indicate number of child-processes (integer values are ignored on Windows) for parallel evaluations (see Details on performance).}

\item{verbose}{Console log output}
}
\value{
tibble with the Google Ads Data.
}
\description{
Get data from Google Ads API
}
\examples{
\dontrun{
# set client id
gads_set_login_customer_id('xxx-xxx-xxxx')

# set manager id if you work under MCC
gads_set_customer_id('xxx-xxx-xxxx')

# default paramas is campaign performance report
campaign_stat <- gads_get_report()


# you can load data from several client accounts at once
# from the same Google Ads MCC
# client ids
accounts <- c('xxx-xxx-xxxx', 'yyy-yyy-yyyy')
# loading data
multi_rep <- gads_get_report(
    date_from = as.Date('2021-06-10'),
    date_to = as.Date('2021-06-17'),
    customer_id = accounts
)

# using more arguments for other reports
group_report <- gads_get_report(
customer_id = 4732519773,
resource    = "ad_group",
fields = c("ad_group.campaign",
           "ad_group.id",
           "ad_group.name",
           "ad_group.status",
           "metrics.clicks",
           "metrics.cost_micros"),
date_from   = "2021-06-10",
date_to     = "2021-06-17",
where       = "ad_group.status = 'ENABLED'",
order_by    = c("metrics.clicks DESC", "metrics.cost_micros"),
limit       = 30000
)
}
}
