% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gn_parse.R
\name{gn_parse}
\alias{gn_parse}
\title{gn_parse}
\usage{
gn_parse(x, format = "compact", threads = NULL)
}
\arguments{
\item{x}{(character) vector of scientific names}

\item{format}{(logical) one of "compact" (default) or "pretty"}

\item{threads}{(integer/numeric) number of threads to run. CPU's
threads number is the default. default: 4}
}
\value{
a list
}
\description{
extract names using gnparser
}
\examples{
trys <- function(x) try(x, silent=TRUE)
if (interactive()) {
x <- c("Quadrella steyermarkii (Standl.) Iltis &amp; Cornejo",
  "Parus major Linnaeus, 1788", "Helianthus annuus var. texanus")
trys(gn_parse(x[1]))
trys(gn_parse(x[2]))
trys(gn_parse(x[3]))
trys(gn_parse(x))
}
}
