% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ee_get.R
\name{ee_get_date_ic}
\alias{ee_get_date_ic}
\title{Get the date of a EE ImageCollection}
\usage{
ee_get_date_ic(x, time_end = FALSE)
}
\arguments{
\item{x}{ee$ImageCollection object}

\item{time_end}{Logical. If TRUE, the \code{system:time_end} property is
also returned. See details.}
}
\value{
A data.frame with the columns: \code{id} (ID of the image),
\code{time_start}, and \code{time_end} (If the argument \code{time_end} is
set as TRUE). The number of rows depends of the number of images
(\code{ee$ImageCollection$size}).
}
\description{
Get the date of a EE ImageCollection
}
\details{
\code{system:time_start} set the start period of data acquisition while
\code{system:time_end} does the same for the end period. See the
\href{https://developers.google.com/earth-engine/glossary/}{Earth Engine glossary}
for getting more information.
}
\examples{
\dontrun{
library(rgee)
library(sf)
ee_Initialize()

nc <- st_read(system.file("shape/nc.shp", package = "sf")) \%>\%
  st_transform(4326) \%>\%
  sf_as_ee()

ee_s2 <- ee$ImageCollection("COPERNICUS/S2")$
  filterDate("2016-01-01", "2016-01-31")$
  filterBounds(nc)

ee_get_date_ic(ee_s2)
}
}
\seealso{
Other date functions: 
\code{\link{ee_get_date_img}()},
\code{\link{eedate_to_rdate}()},
\code{\link{rdate_to_eedate}()}
}
\concept{date functions}
