% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/account_hist.R
\name{account_hist}
\alias{account_hist}
\title{Get Account History For An Account Using Currency}
\usage{
account_hist(currency = "LTC", api.key, secret, passphrase)
}
\arguments{
\item{currency}{Optional character value. The default is \code{"LTC"}. This is case insensitive and must be a valid currency as provided by \code{\link{accounts}} or \code{\link{account}}.}

\item{api.key}{Mandatory character value. This is the API key as generated by GDAX. Typically a 32 character value.}

\item{secret}{Mandatory character value. This is the API secret as generated by GDAX. Typically a 88 character value.}

\item{passphrase}{Mandatory character value. This is the passphrase as generated by GDAX. Typically a 11 character value.}
}
\value{
Dataframe with account activity for that currency. It indiactes the type of activity, when the activity occured and other associated details.
}
\description{
This is an auth based function. User must have valid api keys generated by GADX which must be passed as mandatory arguments. The function takes a currency as an additional input and returns the ledger for that currency. Since currency and account id have one to one mapping, the currency is being used a proxy.
}
\examples{
\dontrun{
account_hist(api.key = your_key, secret = your_api_secret, passphrase = your_api_pass)
account_hist("BTC", api.key = your_key, secret = your_api_secret, passphrase = your_api_pass)
account_hist("ETH", api.key = your_key, secret = your_api_secret, passphrase = your_api_pass)
}

}
