% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csv.R
\name{overwrite_csv_files}
\alias{overwrite_csv_files}
\title{Overwrite FACTS CSV output files}
\usage{
overwrite_csv_files(x)
}
\arguments{
\item{x}{An aggregated data frame from \code{\link[=read_patients]{read_patients()}}
or similar function.}
}
\value{
Nothing.
}
\description{
\code{\link[=read_patients]{read_patients()}} and friends read
CSV output files from FACTS and return special aggregated data frames.
\code{overwite_csv_files()} accepts such an aggregated data frame
and writes the content to the original CSV files it came from.
}
\examples{
facts_file <- get_facts_file_example("contin.facts")
# Can only run if system dependencies are configured:
if (file.exists(Sys.getenv("RFACTS_PATHS"))) {
out <- run_facts(facts_file, n_sims = 2)
pats <- read_patients(out)
head(pats$visit_1)
pats$visit_1 <- 0
overwrite_csv_files(pats)
pats2 <- read_patients(out)
head(pats2$visit_1)
}
}
