% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confusionMatrix.R
\name{confusionMatrix}
\alias{confusionMatrix}
\title{Confusion Matrix}
\usage{
confusionMatrix(rf, conf.level = 0.95, threshold = 0.8)
}
\arguments{
\item{rf}{a \code{\link[randomForest]{randomForest}} object.}

\item{conf.level}{confidence level for the \code{\link{binom.test}} confidence interval}

\item{threshold}{threshold to test observed classification probability against.}
}
\description{
Generate a confusion matrix for Random Forest analyses with 
  error rates translated into percent correctly classified, and columns for 
  confidence intervals and expected classification rates (priors) added.
}
\examples{
data(mtcars)

rf <- randomForest(factor(am) ~ ., mtcars, importance = TRUE)
confusionMatrix(rf)

}
\seealso{
\code{\link{classConfInt}}, \code{\link{exptdErrRate}}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
