% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kgaps.R
\name{kgaps_post}
\alias{kgaps_post}
\title{Random sampling from K-gaps posterior distribution}
\usage{
kgaps_post(data, thresh, k = 1, n = 1000, inc_cens = FALSE,
  alpha = 1, beta = 1, param = c("logit", "theta"),
  use_rcpp = TRUE)
}
\arguments{
\item{data}{A numeric vector of raw data.  No missing values are allowed.}

\item{thresh}{A numeric scalar.  Extreme value threshold applied to data.}

\item{k}{A numeric scalar.  Run parameter \eqn{K}, as defined in Suveges and
Davison (2010).  Threshold inter-exceedances times that are not larger
than \code{k} units are assigned to the same cluster, resulting in a
\eqn{K}-gap equal to zero.  Specifically, the \eqn{K}-gap \eqn{S}
corresponding to an inter-exceedance time of \eqn{T} is given by
\eqn{S = max(T - K, 0)}.}

\item{n}{A numeric scalar. The size of posterior sample required.}

\item{inc_cens}{A logical scalar indicating whether or not to include
contributions from censored inter-exceedance times relating to the
first and last observation.  See Attalides (2015) for details.}

\item{alpha, beta}{Positive numeric scalars.  Parameters of a
beta(\eqn{\alpha}, \eqn{\beta}) prior for \eqn{\theta}.}

\item{param}{A character scalar.  If \code{param = "logit"} (the default)
then we simulate from the posterior distribution of
\eqn{\phi = \log(\theta / (1-\theta))}{\phi = log(\theta / (1-\theta))}
and then transform back to the
\eqn{\theta}-scale.  If \code{param = "theta"} then we simulate
directly from the posterior distribution of \eqn{\theta}, unless
the sample K-gaps are all equal to zero or all positive, when we revert
to \code{param = "logit"}.  This is to avoid sampling directly from a
posterior with mode equal to 0 or 1.}

\item{use_rcpp}{A logical scalar.  If \code{TRUE} (the default) the
rust function \code{\link[rust]{ru_rcpp}} is used for
posterior simulation.  If \code{FALSE} the (slower) function
\code{\link[rust]{ru}} is used.}
}
\value{
An object (list) of class \code{"evpost"}, which has the same
  structure as an object of class \code{"ru"} returned from
  \code{\link[rust]{ru}}.
  In addition this list contains
  \itemize{
    \item{\code{model}:} The character scalar \code{"kgaps"}.
    \item{\code{thresh}:} The argument \code{thresh}.
    \item{\code{ss}:} The sufficient statistics for the K-gaps likelihood,
      as calculated by \code{\link{kgaps_stats}}.
  }
}
\description{
Uses the \code{\link[rust]{rust}} package to simulate from the posterior
distribution of the extremal index \eqn{\theta} based on the K-gaps model
for threshold interexceedance times of Suveges and Davison (2010).
}
\details{
A beta(\eqn{\alpha}, \eqn{\beta}) prior distribution is used for
  \eqn{\theta} so that the posterior from which values are simulated is
  proportional to
  \deqn{\theta ^ {2 N_1 + \alpha - 1} (1 - \theta) ^ {N_0 + \beta - 1}
    \exp\{- \theta q (S_0 + \cdots + S_N)\}.}{%
    \theta ^ (2 N_1 + \alpha - 1) * (1 - \theta) ^ (N_0 + \beta - 1) *
    exp(- \theta q (S_0 + \dots + S_N)).}
  See \code{\link{kgaps_stats}} for a description of the variables
  involved in the contribution of the likelihood to this expression.

  The \code{\link[rust]{ru}} function in the \code{\link[rust]{rust}}
  package simulates from this posterior distribution using the
  generalised ratio-of-uniforms distribution.  To improve the probability
  of acceptance, and to ensure that the simulation will work even in
  extreme cases where the posterior density of \eqn{\theta} is unbounded as
  \eqn{\theta} approaches 0 or 1, we simulate from the posterior
  distribution of
  \eqn{\phi = \log(\theta / (1-\theta))}{\phi = log(\theta / (1-\theta))}
  and then transform back to the \eqn{\theta}-scale.
}
\examples{
thresh <- quantile(newlyn, probs = 0.90)
k_postsim <- kgaps_post(newlyn, thresh)
plot(k_postsim)
}
\references{
Suveges, M. and Davison, A. C. (2010) Model
  misspecification in peaks over threshold analysis, \emph{The Annals of
  Applied Statistics}, \strong{4}(1), 203-221.
  \url{https://doi.org/10.1214/09-AOAS292}

Attalides, N. (2015) Threshold-based extreme value modelling,
  PhD thesis, University College London.
  \url{http://discovery.ucl.ac.uk/1471121/1/Nicolas_Attalides_Thesis.pdf}
}
\seealso{
\code{\link{kgaps_mle}} for maximum likelihood estimation of the
  extremal index \eqn{\theta} using the K-gaps model.

\code{\link{kgaps_stats}} for the calculation of sufficient
  statistics for the K-gaps model.

\code{\link[rust]{ru}} for the form of the object returned by
  \code{kgaps_post}.
}
