% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labelled_spss_survey.R,
%   R/labelled_spss_survey_arithmetic.R
\name{labelled_spss_survey}
\alias{labelled_spss_survey}
\alias{[.retroharmonize_labelled_spss_survey}
\alias{print.retroharmonize_labelled_spss_survey}
\alias{summary.retroharmonize_labelled_spss_survey}
\alias{is.na.retroharmonize_labelled_spss_survey}
\alias{levels.retroharmonize_labelled_spss_survey}
\alias{names<-.retroharmonize_labelled_spss_survey}
\alias{format.retroharmonize_labelled_spss_survey}
\alias{is.labelled_spss_survey}
\alias{median.retroharmonize_labelled_spss_survey}
\alias{quantile.retroharmonize_labelled_spss_survey}
\alias{weighted.mean.retroharmonize_labelled_spss_survey}
\alias{mean.retroharmonize_labelled_spss_survey}
\alias{sum.retroharmonize_labelled_spss_survey}
\title{Labelled SPSS-style vectors with survey provenance}
\usage{
labelled_spss_survey(
  x = double(),
  labels = NULL,
  na_values = NULL,
  na_range = NULL,
  label = NULL,
  id = NULL,
  name_orig = NULL
)

\method{[}{retroharmonize_labelled_spss_survey}(x, i, ...)

labelled_spss_survey(
  x = double(),
  labels = NULL,
  na_values = NULL,
  na_range = NULL,
  label = NULL,
  id = NULL,
  name_orig = NULL
)

\method{[}{retroharmonize_labelled_spss_survey}(x, i, ...)

\method{print}{retroharmonize_labelled_spss_survey}(x, ...)

\method{summary}{retroharmonize_labelled_spss_survey}(object, ...)

\method{is.na}{retroharmonize_labelled_spss_survey}(x)

\method{levels}{retroharmonize_labelled_spss_survey}(x)

\method{names}{retroharmonize_labelled_spss_survey}(x) <- value

\method{format}{retroharmonize_labelled_spss_survey}(x, ..., digits = getOption("digits"))

is.labelled_spss_survey(x)

\method{print}{retroharmonize_labelled_spss_survey}(x, ...)

\method{summary}{retroharmonize_labelled_spss_survey}(object, ...)

\method{is.na}{retroharmonize_labelled_spss_survey}(x)

\method{levels}{retroharmonize_labelled_spss_survey}(x)

\method{names}{retroharmonize_labelled_spss_survey}(x) <- value

\method{format}{retroharmonize_labelled_spss_survey}(x, ..., digits = getOption("digits"))

is.labelled_spss_survey(x)

\method{median}{retroharmonize_labelled_spss_survey}(x, na.rm = TRUE, ...)

\method{quantile}{retroharmonize_labelled_spss_survey}(x, probs, ...)

\method{weighted.mean}{retroharmonize_labelled_spss_survey}(x, w, ...)

\method{mean}{retroharmonize_labelled_spss_survey}(x, ...)

\method{sum}{retroharmonize_labelled_spss_survey}(x, ...)
}
\arguments{
\item{x}{A vector of values.}

\item{labels}{A named vector of value labels.}

\item{na_values}{A vector of values to be treated as missing.}

\item{na_range}{A numeric range defining missing values.}

\item{label}{A variable label.}

\item{id}{A character scalar identifying the survey.}

\item{name_orig}{Original variable name. Defaults to the name of `x`.}

\item{i}{Index vector used for subsetting.}

\item{...}{potentially further arguments for methods; not used in
    the default method.}

\item{object}{A labelled_spss_survey to summarize.}

\item{value}{Replacement values used when assigning names.}

\item{digits}{Number of digits to use in string representation in 
the format method.}

\item{na.rm}{a logical value indicating whether \code{NA}
    values should be stripped before the computation proceeds.}

\item{probs}{numeric vector of probabilities with values in
    \eqn{[0,1]}.  (Values up to \samp{2e-14} outside that
    range are accepted and moved to the nearby endpoint.)}

\item{w}{a numerical vector of weights the same length as \code{x} giving
    the weights to use for elements of \code{x}.}
}
\value{
An object of class `"retroharmonize_labelled_spss_survey"`,
extending [haven::labelled_spss()].

An object of class `"retroharmonize_labelled_spss_survey"`,
extending [haven::labelled_spss()].
}
\description{
Create a labelled vector compatible with
[haven::labelled_spss()] that carries additional
survey-level provenance metadata.

Create a labelled vector compatible with
[haven::labelled_spss()] that carries additional
survey-level provenance metadata.
}
\details{
The resulting object behaves like a
`haven_labelled_spss` vector, but stores:
\itemize{
  \item a survey identifier
  \item the original variable name
  \item the original value coding
}


Several arithmetic (statistical summary) methods operate on the
numeric representation of labelled survey vectors, converting 
SPSS-style missing values to `NA`
before computation.

You can coerce labelled_spss_survey vectors to numeric, 
character or factor representation.

The resulting object behaves like a
`haven_labelled_spss` vector, but stores:
\itemize{
  \item a survey identifier
  \item the original variable name
  \item the original value coding
}


Several arithmetic (statistical summary) methods operate on the
numeric representation of labelled survey vectors, converting 
SPSS-style missing values to `NA`
before computation.

You can coerce labelled_spss_survey vectors to numeric, 
character or factor representation.
}
\examples{
x <- labelled_spss_survey(
  x = c(1, 2, 9),
  labels = c(Yes = 1, No = 2),
  na_values = 9,
  id = "survey_1"
)

is.na(x)
as_factor(x)

x <- labelled_spss_survey(
  x = c(1, 2, 9),
  labels = c(Yes = 1, No = 2),
  na_values = 9,
  id = "survey_1"
)

is.na(x)
as_factor(x)

}
\seealso{
[haven::labelled_spss()],
[as_factor()],
[as_numeric()], 
[as_character()]

[haven::labelled_spss()],
[as_factor()],
[as_numeric()], 
[as_character()]
}
