% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometry.R
\name{bary.to.sphere.cart}
\alias{bary.to.sphere.cart}
\title{Convert barycentric coordinates of points in mesh on sphere
to cartesian coordinates}
\usage{
bary.to.sphere.cart(phi, lambda, R, Tt, cb)
}
\arguments{
\item{phi}{Latitudes of mesh points}

\item{lambda}{Longitudes of mesh points}

\item{R}{Radius of sphere}

\item{Tt}{Triangulation}

\item{cb}{Object returned by \link{tsearch} containing information on the
triangle in which a point occurs and the barycentric coordinates
within that triangle}
}
\value{
An N-by-3 matrix of the Cartesian coordinates of the points
}
\description{
Given a triangular mesh on a sphere described by mesh locations
(\code{phi}, \code{lambda}), a radius \code{R} and a triangulation
\code{Tt}, determine the Cartesian coordinates of points \code{cb}
given in barycentric coordinates with respect to the mesh.
}
\author{
David Sterratt
}
