% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restopt_solution.R
\name{get_metadata}
\alias{get_metadata}
\title{Restopt solution metadata}
\usage{
get_metadata(restopt_solution, area_unit = "ha", distance_unit = "m")
}
\arguments{
\item{restopt_solution}{\code{\link[=restopt_solution]{restopt_solution()}} Restopt solution
to this solution.}

\item{area_unit}{\code{unit} object or a \code{character} that can be coerced to an area
unit (see \code{unit} package), or "cells" for number of cells from the original
habitat raster). Unit for areas. If the input habitat raster does not use a projected
coordinate system, only "cells" is available. Default is "ha"}

\item{distance_unit}{\code{unit} object or a \code{character} that can be coerced to an area
unit (see \code{unit} package), or "cells" for number of cell width from the original
habitat raster). Unit for distances. If the input habitat raster does not use a projected
coordinate system, only "cells" is available. Default is "m"}
}
\value{
A \code{list} containing the characteristics of the restopt solution.
}
\description{
Return the metadata associated with a restopt solution, which contains
the characteristics of the solution. The unit for area characteristics
can be chosen among "ha" (hectares), "m" (square meters), "km" (square
kilometers), and "cells" (cells from the original input habitat raster).
Note that the solving time is expressed in seconds.
}
