% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/co2_rate.R
\encoding{UTF-8}
\name{co2_rate}
\alias{co2_rate}
\title{Calculate CO2 to add to a respirometer intake flow}
\usage{
co2_rate(goal_pco2, init_pH, flow_rate, temp = 25, sal = 35, TA = NULL,
  atm_pres = 1013.25, MO2 = NULL, RQ = 1)
}
\arguments{
\item{goal_pco2}{the desired pCO2 in the respirometer (uatm).}

\item{init_pH}{ambient pH of the intake flow (total scale).}

\item{flow_rate}{rate of water flow into the respirometer (liters / minute).}

\item{temp}{temperature (°C). Default is 25 °C.}

\item{sal}{salinity (psu). Default is 35 psu. If \code{sal} < 26 psu, then \code{TA} must be provided.}

\item{TA}{(optional) total alkalinity (umol / kg). If undefined TA is estimated from salinity using \code{\link{guess_TA}}.}

\item{atm_pres}{atmospheric pressure (mbar). Default is 1013.25 mbar.}

\item{MO2}{(optional) oxygen consumption rate (umol / hr). If defined, the CO2 to be added is reduced to compensate for the CO2 produced by the organism.}

\item{RQ}{(optional) respiratory quotient: ratio of CO2 produced / O2 consumed. Only used if \code{MO2} is defined. Default is 1.}
}
\value{
moles of CO2 gas to be added to the intake flow per minute.
}
\description{
Calculates the moles of CO2 gas to be added to a respirometer intake seawater flow to achieve the desired pCO2 in the respirometer. Useful for ocean acidification experiments where CO2 treatments are desired. Can be used for acclimation before a trial begins or for use with flow-through respirometry.
}
\note{
It is assumed that all of the CO2 added dissolves and remains in solution. This can be achieved (almost completely) by bubbling CO2 according to Jokiel et al. 2014.
}
\examples{
# I want the respirometer to have a pCO2 = 1000 uatm. How much CO2 per minute do I need
# to add to the intake flow if the ambient pH is 8.1 and it is flowing at 3 LPM?
co2_rate(goal_pco2 = 1000, init_pH = 8.1, flow_rate = 3)

}
\references{
Jokiel PL, Bahr KD, Rodgers KS. 2014. Low-cost, high-flow mesocosm system for simulating ocean acidification with CO2 gas. Limnol Oceanogr Methods. 12:313–322.
}
\seealso{
\code{\link{co2_add}}, \code{\link{flush_carb}}, \code{\link[seacarb]{carb}}, \code{\link{peri_pump}}
}
\author{
Matthew A. Birk, \email{matthewabirk@gmail.com}
}
