% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flush_carb.R
\encoding{UTF-8}
\name{flush_carb}
\alias{flush_carb}
\title{Estimate carbonate chemistry after a flush}
\usage{
flush_carb(resp_vol, flow_rate, duration, resp_pH, flush_pH, temp = 25,
  sal = 35, TA = NULL, atm_pres = 1013.25)
}
\arguments{
\item{resp_vol}{volume of the respirometer (liter).}

\item{flow_rate}{rate of water flow into the respirometer (liters / minute).}

\item{duration}{duration of the flush (minutes).}

\item{resp_pH}{pH inside the respirometer before the flush (total scale).}

\item{flush_pH}{pH of the water used for flushing the respirometer (total scale).}

\item{temp}{temperature (°C). Default is 25 °C.}

\item{sal}{salinity (psu). Default is 35 psu. If \code{sal} < 26 psu, then \code{TA} must be provided.}

\item{TA}{(optional) total alkalinity (umol / kg). If undefined TA is estimated from salinity using \code{\link{guess_TA}}.}

\item{atm_pres}{atmospheric pressure (mbar). Default is 1013.25 mbar.}
}
\value{
A data frame returned by \code{\link[seacarb]{carb}}.
}
\description{
Given the seawater pH inside the respirometer and in the flush reservoir, the new carbonate parameters (including pH) in the respirometer after the flush are estimated.
}
\examples{
flush_carb(resp_vol = 90, flow_rate = 10, duration = 3, resp_pH = 7.8, flush_pH = 8.1)

# What will be the pH in the respirometer after this flush?
flush_carb(resp_vol = 90, flow_rate = 10, duration = 3, resp_pH = 7.8, flush_pH = 8.1)$pH

}
\seealso{
\code{\link[seacarb]{carb}}, \code{\link{flush_water}}
}
\author{
Matthew A. Birk, \email{matthewabirk@gmail.com}
}
