% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_data.R
\name{get_parameters}
\alias{get_parameters}
\title{Download time series of sea-state parameters from RESOURCECODE database}
\usage{
get_parameters(
  parameters = "hs",
  node = 42,
  start = as.POSIXct("1994-01-01 00:00:00", tz = "UTC"),
  end = as.POSIXct("1994-12-31 23:00:00", tz = "UTC")
)
}
\arguments{
\item{parameters}{character vector of sea-state parameters}

\item{node}{single integer with the node to get}

\item{start}{starting date (as integer, character or posixct)}

\item{end}{ending date (as integer, character or posixct)}
}
\value{
a tibble with N-rows and \code{length(parameters)} columns.
}
\description{
Download time series of sea-state parameters from RESOURCECODE database
}
\examples{
\dontshow{if (requireNamespace("resourcecodedata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
ts <- get_parameters(parameters = c("hs", "tp"), node = 42)
plot(ts$time, ts$hs, type = "l")
\dontshow{\}) # examplesIf}
}
