% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resmush_url.R
\name{resmush_url}
\alias{resmush_url}
\title{Optimize an online file}
\usage{
resmush_url(
  url,
  outfile = file.path(tempdir(), basename(url)),
  overwrite = FALSE,
  progress = TRUE,
  report = TRUE,
  qlty = 92,
  exif_preserve = FALSE
)
}
\arguments{
\item{url}{url or a vector of urls pointing to hosted image files.
\strong{reSmush} can optimize the following image files:
\itemize{
\item \code{png}
\item \code{jpg/jpeg}
\item \code{gif}
\item \code{bmp}
\item \code{tiff}
\item \code{webp}
}}

\item{outfile}{Path or paths where the optimized files would be store in
your disk. By default, temporary files (see \code{\link[=tempfile]{tempfile()}}) with the same
\code{\link[=basename]{basename()}} than the file provided in \code{url} would be created. It should be
of the same length than \code{url} parameter.}

\item{overwrite}{Logical. Should \code{outfile} be overwritten (if already
exists)? If \code{FALSE} and \code{outfile} exists it would create a copy with
a numerical suffix (i.e. \verb{<outfile>.png}, \verb{<outfile>_01.png}, etc.).}

\item{progress}{Logical. Display a progress bar when needed.}

\item{report}{Logical. Display a summary report of the process in the
console. See also \strong{Value}.}

\item{qlty}{Only affects \code{jpg} files. Integer between 0 and 100 indicating
the optimization level. For optimal results use vales above 90.}

\item{exif_preserve}{Logical. Should the
\href{https://en.wikipedia.org/wiki/Exif}{Exif} information (if any) deleted?
Default is to remove it (i.e. \code{exif_preserve = FALSE}).}
}
\value{
Writes on disk the optimized file if the API call is successful.
In all cases, a (invisible) data frame with a summary of the process is
returned as well.

If any value of the vector \code{outfile} is duplicated, \code{resmush_url()} would
rename the output with a suffix \verb{_01. _02}, etc.
}
\description{
Optimize and download an online image using the
\href{https://resmush.it/}{reSmush.it API}.
}
\examples{
\dontshow{if (curl::has_internet()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

\donttest{

# Base url
base_url <- "https://raw.githubusercontent.com/dieghernan/resmush/main/inst/"

png_url <- paste0(base_url, "/extimg/example.png")
resmush_url(png_url)

# Several urls
jpg_url <- paste0(base_url, "/extimg/example.jpg")


summary <- resmush_url(c(png_url, jpg_url))

# Returns an (invisible) data frame with a summary of the process
summary

# Display with png
if (require("png", quietly = TRUE)) {
  my_png <- png::readPNG(summary$dest_img[1])
  grid::grid.raster(my_png)
}

# Use with jpg and parameters
resmush_url(jpg_url)
resmush_url(jpg_url, qlty = 10)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\href{https://resmush.it/api/}{reSmush.it API} docs.

Other functions for optimizing:
\code{\link{resmush_dir}()},
\code{\link{resmush_file}()}
}
\concept{optimize}
