% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_normal.R
\name{dist_normal}
\alias{dist_normal}
\title{Normal distribution}
\usage{
dist_normal(mean = NULL, sd = NULL)
}
\arguments{
\item{mean}{Scalar mean parameter, or \code{NULL} as a placeholder.}

\item{sd}{Scalar standard deviation parameter, or \code{NULL} as a placeholder.}
}
\value{
A \code{NormalDistribution} object.
}
\description{
See \link[stats:Normal]{stats::Normal}.
}
\details{
Both parameters can be overridden with
\code{with_params = list(mean = ..., sd = ...)}.
}
\examples{
mu <- 0
sigma <- 1

d_norm <- dist_normal(mean = mu, sd = sigma)
x <- d_norm$sample(20)
d_emp <- dist_empirical(x)

plot_distributions(
  empirical = d_emp,
  theoretical = d_norm,
  estimated = d_norm,
  with_params = list(
    estimated = list(mean = mean(x), sd = sd(x))
  ),
  .x = seq(-3, 3, length.out = 100)
)

}
\seealso{
Other Distributions: 
\code{\link{Distribution}},
\code{\link{dist_bdegp}()},
\code{\link{dist_beta}()},
\code{\link{dist_binomial}()},
\code{\link{dist_blended}()},
\code{\link{dist_dirac}()},
\code{\link{dist_discrete}()},
\code{\link{dist_empirical}()},
\code{\link{dist_erlangmix}()},
\code{\link{dist_exponential}()},
\code{\link{dist_gamma}()},
\code{\link{dist_genpareto}()},
\code{\link{dist_lognormal}()},
\code{\link{dist_mixture}()},
\code{\link{dist_negbinomial}()},
\code{\link{dist_pareto}()},
\code{\link{dist_poisson}()},
\code{\link{dist_translate}()},
\code{\link{dist_trunc}()},
\code{\link{dist_uniform}()},
\code{\link{dist_weibull}()}
}
\concept{Distributions}
