% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Urerf.R
\name{Urerf}
\alias{Urerf}
\title{Unsupervised RerF forest Generator}
\usage{
Urerf(X, trees = 100, min.parent = round(nrow(X)^0.5),
  max.depth = NA, mtry = ceiling(ncol(X)^0.5), normalizeData = TRUE,
  Progress = TRUE)
}
\arguments{
\item{X}{an n by d numeric matrix. The rows correspond to observations and columns correspond to features.}

\item{trees}{the number of trees in the forest. (trees=100)}

\item{min.parent}{the minimum splittable node size.  A node size < min.parent will be a leaf node. (min.parent = round(nrow(X)^.5))}

\item{max.depth}{the longest allowable distance from the root of a tree to a leaf node (i.e. the maximum allowed height for a tree).  If max.depth=NA, the tree will be allowed to grow without bound.  (max.depth=NA)}

\item{mtry}{the number of features to test at each node.  (mtry=ceiling(ncol(X)^.5))}

\item{normalizeData}{a logical value that determines if input data is normalized to values ranging from 0 to 1 prior to processing.  (normalizeData=TRUE)}

\item{Progress}{boolean for printing progress.}
}
\value{
urerfStructure
}
\description{
Creates a decision forest based on an input matrix.
}
\examples{
### Train RerF on numeric data ###
library(rerf)
urerfStructure <- Urerf(as.matrix(iris[, 1:4]))

dissimilarityMatrix <- hclust(as.dist(1 - urerfStructure$similarityMatrix), method = "mcquitty")
clusters <- cutree(dissimilarityMatrix, k = 3)
}
