% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fipscounty.R
\name{fipscounty}
\alias{fipscounty}
\title{Convert a FIPS County Code to/from a County Name}
\usage{
fipscounty(county = NULL, code = NULL, url = eurl(), ...)
}
\arguments{
\item{county}{character; A county name.}

\item{code}{numeric; A FIPS code.}

\item{url}{A URL for an ERDDAP server. Default:
\url{https://upwell.pfeg.noaa.gov/erddap/}. See \code{\link[=eurl]{eurl()}} for
more information}

\item{...}{Curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\description{
Convert a FIPS County Code to/from a County Name
}
\examples{
 \dontrun{
fipscounty(code = "06053")
fipscounty(county = "CA, Monterey")
fipscounty(county = "OR, Multnomah")
}
}
