% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/calculate_elcc.R
\name{calculate_elcc}
\alias{calculate_elcc}
\title{Calculate effective load carrying capability (ELCC)}
\usage{
calculate_elcc(time.data, outage.table, obj.metric = "LOLE",
  obj.value = 0.1, scale.load = FALSE, max.iter = 20, ignore = NULL,
  ...)
}
\arguments{
\item{time.data}{Time series data formatted with \code{\link{format_timedata}}}

\item{outage.table}{Outage table used in the lookup, created with \code{\link{outage_table}}}

\item{obj.metric}{Metric to be used as objective: \code{LOLE, LOLH, PeakLOLP, EUE} (see details)}

\item{obj.value}{Objective value to achieve for the selected metric}

\item{scale.load}{During the iterations is the load scaled (\code{TRUE}) or the same value added to all times (\code{FALSE})}

\item{max.iter}{Maximum iterations to perform before stopping}

\item{ignore}{Column names in \code{time.data} to ignore in the calculation of total VG data}

\item{...}{Additional parameters passed to \code{\link{sliding_window}}}
}
\description{
Given a time data object (with net load data), find the effective load carrying capability (ELCC) to achieve
the desired reliability metric. The function automatically
applies these calculation for each scenario, level or aggregation and area.
}
\details{
The following metrics can be selected as an objective (through \code{obj.metric}):
\itemize{
  \item{Daily loss of load expectation (\code{LOLE}): Calculated as the sum of the maximum daily LOLP}
  \item{Loss of load hours (\code{LOLH}): Sum of all the LOLP}
  \item{Maximum daily LOLP (\code{PeakLOLP}): Maximum LOLP value observed}
  \item{Expected unserved energy (\code{EUE}): Sum of EUE for all time steps}
}

ELCC is calculated by modifying the load profile so that the final profile yields a certain reliability
level. This can be done in two ways:
\itemize{
  \item{by scaling the entire profile (e.g., by multiplying the entire time series by 1.05)}
  \item{by adding a constant number to the entire profiles (e.g., adding 100 MW)}
}

\code{scale.load} needs to be set to \code{TRUE} or \code{FALSE} to achieve either one, respectively.
}
\examples{
# Create outage table with 200 5-MW units
gens <- data.frame(Capacity = rep(5, 200),
                   EFOR = rep(0.08, 200))
out.table <- outage_table(gens)

# Create random load and wind data and format
tdata <- data.frame(Time = 1:8760,
                    Load = runif(8760, 450, 850),
                    Wind = runif(8760, 0, 100),
                    Wind2 = runif(8760, 0, 200))
td <- format_timedata(tdata)

# Calculate ELCC with both Wind and Wind2
calculate_elcc(td, out.table)

# Calculate ELCC with only Wind
calculate_elcc(td, out.table, ignore = "Wind2")
}
\seealso{
\code{\link{format_timedata}} and \code{\link{outage_table}} to create \code{time.data}
         and \code{outage.table} objects, respectively

\code{\link{sliding_window}} is used internally to extend \code{time.data}

\code{\link{calculate_metrics}} is used internally to evaluate the metrics
}

