% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_text.R
\name{report_text}
\alias{report_text}
\title{Report a textual description of an object}
\usage{
report_text(x, table = NULL, ...)
}
\arguments{
\item{x}{The R object that you want to report (see list of of supported
objects above).}

\item{table}{A table obtained via \code{report_table()}. If not provided,
will run it.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
An object of class \code{\link{report_text}}.
}
\description{
Creates text containing a description of the parameters of R objects (see
list of supported objects in \code{\link{report}}).
}
\examples{
library(report)

# Miscellaneous
r <- report_text(sessionInfo())
r
summary(r)

# Data
report_text(iris$Sepal.Length)
report_text(as.character(round(iris$Sepal.Length, 1)))
report_text(iris$Species)
report_text(iris)

# h-tests
report_text(t.test(iris$Sepal.Width, iris$Sepal.Length))
report_text(cor.test(iris$Sepal.Width, iris$Sepal.Length))

# ANOVA
r <- report_text(aov(Sepal.Length ~ Species, data = iris))
r
summary(r)

# GLMs
r <- report_text(lm(Sepal.Length ~ Petal.Length * Species, data = iris))
r
summary(r)
\donttest{
if (require("lme4")) {
  model <- lme4::lmer(Sepal.Length ~ Petal.Length + (1 | Species), data = iris)
  r <- report_text(model)
  r
  summary(r)
}

# Bayesian models
if (require("rstanarm")) {
  model <- stan_glm(mpg ~ cyl + wt, data = mtcars, refresh = 0, iter = 600)
  r <- report_text(model)
  r
  summary(r)
}
}
}
