% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/JSONGenerator.R
\name{objectAsJSON}
\alias{objectAsJSON}
\title{Convert an ejObject into JSON}
\usage{
objectAsJSON(object)
}
\arguments{
\item{object}{The object to be converted to JSON}
}
\description{
Convert an ejObject into JSON
}
\examples{
library(sp)
library(rgdal)

#create an attribute
attribute <- create_ejAttribute("A test attribute","number",5.2,"metres")

#generate a polygon
polyPoints <- matrix(c(526870,181390,526817,181447,526880,181467,
		526885,181447,526909,181425,526870,181390),ncol=2,byrow=TRUE)
demoPolygon <- SpatialPolygons(list(Polygons(list(Polygon(polyPoints)),"1")),
		proj4string=CRS("+init=epsg:27700"))

#create an event
event <- create_ejEvent(id=1, name="A test Event", date=Sys.time(),
		location=demoPolygon, attributes=list(attribute, attribute))

#create a record
record <- create_ejRecord(id=1, attributes=list(attribute,attribute),
		events=list(event,event))

#generate some metadata
metadata <- create_ejMetadata(list(attribute, attribute))

#create an EpiJSON object
object <- create_ejObject(metadata=metadata, records=list(record,record))

#print it as JSON
objectAsJSON(object)
}

