% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nice_mod.R
\name{nice_mod}
\alias{nice_mod}
\title{Easy moderations}
\usage{
nice_mod(
  data,
  response,
  predictor,
  moderator,
  moderator2 = NULL,
  covariates = NULL,
  b.label = "b",
  mod.id = TRUE,
  ...
)
}
\arguments{
\item{data}{The data frame}

\item{response}{The dependent variable.}

\item{predictor}{The independent variable.}

\item{moderator}{The moderating variable.}

\item{moderator2}{The second moderating variable, if applicable.}

\item{covariates}{The desired covariates in the model.}

\item{b.label}{What to rename the default "b" column (e.g.,
to capital B if using standardized data for it to be converted
to the Greek beta symbol in the \code{nice_table} function).}

\item{mod.id}{Logical. Whether to display the model number,
when there is more than one model.}

\item{...}{Further arguments to be passed to the \code{lm}
function for the models.}
}
\value{
A formatted dataframe of the specified lm model, with DV, IV, degrees
of freedom, regression coefficient, t-value, p-value, and the effect
size, the semi-partial correlation squared.
}
\description{
Easily compute moderation analyses, with effect
sizes, and format in publication-ready format.

Note: this function uses the \code{modelEffectSizes} function from
the \code{lmSupport} package to get the sr2 effect sizes.
}
\examples{
# Make the basic table
nice_mod(
  data = mtcars,
  response = "mpg",
  predictor = "gear",
  moderator = "wt"
)

# Multiple dependent variables at once
nice_mod(
  data = mtcars,
  response = c("mpg", "disp", "hp"),
  predictor = "gear",
  moderator = "wt"
)

# Add covariates
nice_mod(
  data = mtcars,
  response = "mpg",
  predictor = "gear",
  moderator = "wt",
  covariates = c("am", "vs")
)

# Three-way interaction
nice_mod(
  data = mtcars,
  response = "mpg",
  predictor = "gear",
  moderator = "wt",
  moderator2 = "am"
)

}
\seealso{
Checking simple slopes after testing for moderation:
\code{\link{nice_slopes}}, \code{\link{nice_lm}},
\code{\link{nice_lm_slopes}}. Tutorial:
\url{https://rempsyc.remi-theriault.com/articles/moderation}
}
\keyword{interaction}
\keyword{moderation}
\keyword{regression}
