% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agent.R
\name{makeAgent}
\alias{makeAgent}
\title{Create Agent.}
\usage{
makeAgent(policy, val.fun = NULL, algorithm = NULL,
  preprocess = identity, replay.memory = NULL, policy.args = list(),
  val.fun.args = list(), algorithm.args = list())
}
\arguments{
\item{policy}{[\code{character(1)} | Policy] \cr A policy.
If you pass a string the policy will be created via \link{makePolicy}.}

\item{val.fun}{[\code{character(1)} | ValueFunction] \cr A value function representation.
If you pass a string the value function will be created via \link{makeValueFunction}.}

\item{algorithm}{[\code{character(1)} | Algorithm] \cr An algorithm.
If you pass a string the algorithm will be created via \link{makeAlgorithm}.}

\item{preprocess}{[\code{function}] \cr A function which preprocesses the state so that the agent can learn on this.}

\item{replay.memory}{[\code{ReplayMemory}] \cr Replay memory for experience replay created by \link{makeReplayMemory}.}

\item{policy.args}{[\code{list}] \cr Arguments passed on to \code{args} in \link{makePolicy}.}

\item{val.fun.args}{[\code{list}] \cr Arguments passed on to \code{args} in \link{makeValueFunction}.}

\item{algorithm.args}{[\code{list}] \cr Arguments passed on to \code{args} in \link{makeAlgorithm}.}
}
\description{
An agent consists of a policy and (optional) a value function representation
and (optional) a learning algorithm.
}
\examples{
agent = makeAgent("softmax", "table", "qlearning")
}
