\name{expand.call}
\alias{expand.call}
\title{Return call with all possible arguments}
\usage{
  expand.call(definition = NULL, call =
  sys.call(sys.parent(1)), expand.dots = TRUE)
}
\arguments{
  \item{definition}{a function. See
  \code{\link[base]{match.call}}.}

  \item{call}{an unevaluated call to the function specified
  by definition. See \code{\link[base]{match.call}}.}

  \item{expand.dots}{logical. Should arguments matching ...
  in the call be included or left as a ... argument? See
  \code{\link[base]{match.call}}.}
}
\value{
  An object of mode "\code{\link[base]{call}}".
}
\description{
  Return a call in which all of the arguments which were
  supplied or have presets are specified by their full
  names and their supplied or default values.
}
\author{
  Fabian Scheipl
}
\seealso{
  \code{\link[base]{match.call}}
}

