% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lofocv.R
\name{lofocv}
\alias{lofocv}
\title{Leave-one-function-out cross-validation}
\usage{
lofocv(Y, X, S1, argvals, lamvec = NULL, constr = NULL,
  maxlam = NULL)
}
\arguments{
\item{Y}{matrix of responses, e.g. with columns corresponding to basis
function coefficients.}

\item{X}{model matrix.}

\item{S1}{penalty matrix.}

\item{argvals}{values where the functions are evaluated}

\item{lamvec}{vector of candidate smoothing parameter values.  If
\code{NULL}, smoothing parameter is chosen by \code{\link{optimize}}.}

\item{constr}{matrix of linear constraints.}

\item{maxlam}{maximum smoothing parameter value to consider (when
\code{lamvec=NULL}).}
}
\value{
if \code{lamvec=NULL}, a list (returned by \code{optimize}) with
elements \code{minimum} and \code{objective} giving, respectively, the
chosen smoothing parameter and the associated cross-validation score.
Otherwise a 2-column table with the candidate smoothing parameters in the
first column and the corresponding cross-validation scores in the second.
}
\description{
This internal function, called by \code{fosr()} when \code{method="OLS"},
performs efficient leave-one-function-out cross-validation using
Demmler-Reinsch orthogonalization to choose the smoothing parameter.
}
\seealso{
\code{\link{fosr}}, \code{\link{pwcv}}
}
\author{
Philip Reiss \email{phil.reiss@nyumc.org} and Lei Huang
}
\keyword{internal}
