% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refseq_XMfromXP.R
\name{refseq_XMfromXP}
\alias{refseq_XMfromXP}
\title{Get the XM accession from XP accession}
\usage{
refseq_XMfromXP(xp)
}
\arguments{
\item{xp}{A character string of the XP id.}
}
\value{
A character vector containing the XM ids that encode the XP especified as \code{xp}.
}
\description{
\code{refseq_XMfromXP()} Returns the XM accession from a single XP accession.
}
\examples{
 # Get the XM id from a single XP accession
 xp <- "XP_020244413"
 refseq_XMfromXP(xp)

\donttest{
 # Get the XM ids from a set of XP accessions
 xp = c("XP_004487758", "XP_004488550")
 sapply(xp, function(x) refseq_XMfromXP(x), USE.NAMES = FALSE)}

}
\seealso{
\code{\link{refseq_XPfromXM}} to obtain the XP ids encoded by a set of XM ids.
}
\author{
Jose V. Die
}
