% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_deprecations.R, R/deprecations.R
\name{distr_compactness}
\alias{distr_compactness}
\alias{redist.compactness}
\title{Calculate compactness measures for a set of plans}
\usage{
distr_compactness(map, measure = "FracKept", .data = cur_plans(), ...)

redist.compactness(
  shp = NULL,
  plans,
  measure = c("PolsbyPopper"),
  total_pop = NULL,
  adj = NULL,
  draw = 1,
  ncores = 1,
  counties = NULL,
  planarize = 3857,
  ppRcpp,
  perim_path,
  perim_df
)
}
\arguments{
\item{map}{a \code{\link{redist_map}} object}

\item{measure}{A vector with a string for each measure desired. "PolsbyPopper",
"Schwartzberg", "LengthWidth", "ConvexHull", "Reock", "BoyceClark", "FryerHolden",
"EdgesRemoved", "FracKept", and "logSpanningTree" are implemented. Defaults to "PolsbyPopper". Use "all" to
return all implemented measures.}

\item{.data}{a \code{\link{redist_plans}} object}

\item{...}{passed on to \code{redist.compactness}}

\item{shp}{A SpatialPolygonsDataFrame or sf object. Required unless "EdgesRemoved"
and "logSpanningTree" with adjacency provided.}

\item{plans}{A numeric vector (if only one map) or matrix with one row
for each precinct and one column for each map. Required.}

\item{total_pop}{A numeric vector with the population for every observation. Is
only necessary when "FryerHolden" is used for measure. Defaults to NULL.}

\item{adj}{A zero-indexed adjacency list. Only used for "PolsbyPopper",
EdgesRemoved" and "logSpanningTree". Created with \code{redist.adjacency} if not
supplied and needed. Default is NULL.}

\item{draw}{A numeric to specify draw number. Defaults to 1 if only one map provided
and the column number if multiple maps given. Can also take a factor input, which will become the
draw column in the output if its length matches the number of entries in plans. If the \code{plans} input
is a \code{redist_plans} object, it extracts the \code{draw} identifier.}

\item{ncores}{Number of cores to use for parallel computing. Default is 1.}

\item{counties}{A numeric vector from 1:ncounties corresponding to counties. Required for "logSpanningTree".}

\item{planarize}{a number, indicating the CRS to project the shapefile to if
it is latitude-longitude based. Set to FALSE to avoid planarizing.}

\item{ppRcpp}{Boolean, whether to run Polsby Popper and Schwartzberg using Rcpp.
It has a higher upfront cost, but quickly becomes faster.
Becomes TRUE if ncol(district_membership > 8) and not manually set.}

\item{perim_path}{it checks for an Rds, if no rds exists at the path,
it creates an rds with borders and saves it.
This can be created in advance with \code{\link[=prep_perims]{prep_perims()}}.}

\item{perim_df}{A dataframe output from \code{\link[=prep_perims]{prep_perims()}}.}
}
\value{
A tibble with a column that specifies the district, a column for
each specified measure, and a column that specifies the map number.
}
\description{
\code{redist.compactness} is used to compute different compactness statistics for a
shapefile. It currently computes the Polsby-Popper, Schwartzberg score, Length-Width Ratio,
Convex Hull score, Reock score, Boyce Clark Index, Fryer Holden score, Edges Removed number,
and the log of the Spanning Trees.
}
\details{
This function computes specified compactness scores for a map.  If
there is more than one shape specified for a single district, it combines
them, if necessary, and computes one score for each district.

Polsby-Popper is computed as \deqn{\frac{4*\pi*A(d)}{P(d)^2}} where A is the area
function, the district is d, and P is the perimeter function. All  values are between
0 and 1, where larger values are more compact.

Schwartzberg is computed as \deqn{\frac{P(d)}{2*\pi*\sqrt{\frac{A(d)}{\pi}}}}
where A is the area function, the district is d, and P is the perimeter function.
All  values are between 0 and 1, where larger values are more compact.

The Length Width ratio is computed as \deqn{\frac{length}{width}} where length
is the shorter of the maximum x distance and the maximum y distance. Width is
the longer of the two values. All  values are between 0 and 1, where larger
values are more compact.

The Convex Hull score is computed as \deqn{\frac{A(d)}{A(CVH)}} where A is the area
function, d is the district, and CVH is the convex hull of the district. All
values are between 0 and 1, where larger values are more compact.

The Reock score is computed as \deqn{\frac{A(d)}{A(MBC)}} where A is the area
function, d is the district, and MBC is the minimum bounding circle of the
district. All values are between 0 and 1, where larger values are more compact.

The Boyce Clark Index is computed as \deqn{1 - \sum_{1}^{16}\{\frac{|\frac{r_i}{\sum_ir_i}*100-6.25 |\}}{200}}.
The \eqn{r_i} are the distances of the 16 radii computed from the geometric
centroid of the shape to the most outward point of the shape that intersects
the radii, if the centroid is contained within the shape.  If the centroid
lies outside of the shape, a point on the surface is used, which will naturally
incur a penalty to the score. All  values are between 0 and 1,
where larger values are more compact.

The Fryer Holden score for each district is computed with \deqn{Pop\odot D(precinct)^2},
where \eqn{Pop} is the population product matrix.  Each element is the
product of the i-th and j-th precinct's populations.  D represents the distance,
where the matrix is the distance between each precinct.  To fully compute this
index, for any map, the sum of these values should be used as the numerator.
The denominator can be calculated from the full enumeration of districts as the
smallest calculated numerator. This produces very large numbers, where smaller
values are more compact.

The log spanning tree measure is the logarithm of the product of the
number of spanning trees which can be drawn on each district.

The edges removed measure is number of edges removed from the underlying adjacency graph.
A smaller number of edges removed is more compact.

The fraction kept measure is the fraction of edges that were not removed from the
underlying adjacency graph. This takes values 0 - 1, where 1 is more compact.
}
\examples{
data(fl25)
data(fl25_enum)

plans_05 <- fl25_enum$plans[, fl25_enum$pop_dev <= 0.05]

# old redist.compactness(
#     shp = fl25, plans = plans_05[, 1:3],
#     measure = c("PolsbyPopper", "EdgesRemoved")
# )
comp_polsby(plans_05[, 1:3], fl25)
comp_edges_rem(plans_05[, 1:3], fl25, fl25$adj)
}
\references{
Boyce, R., & Clark, W. 1964. The Concept of Shape in Geography.
Geographical Review, 54(4), 561-572.

Cox, E. 1927. A Method of Assigning Numerical and Percentage Values to the
Degree of Roundness of Sand Grains. Journal of Paleontology, 1(3), 179-183.

Fryer R, Holden R. 2011. Measuring the Compactness of Political Districting Plans.
Journal of Law and Economics.

Harris, Curtis C. 1964. “A scientific method of districting”.
Behavioral Science 3(9), 219–225.

Maceachren, A. 1985. Compactness of Geographic Shape: Comparison and
Evaluation of Measures. Geografiska Annaler. Series B, Human Geography, 67(1),
53-67.

Polsby, Daniel D., and Robert D. Popper. 1991. “The Third Criterion:
Compactness as a procedural safeguard against partisan gerrymandering.”
Yale Law & Policy Review 9 (2): 301–353.

Reock, E. 1961. A Note: Measuring Compactness as a Requirement of Legislative
Apportionment. Midwest Journal of Political Science, 5(1), 70-74.

Schwartzberg, Joseph E. 1966. Reapportionment, Gerrymanders, and the Notion
of Compactness. Minnesota Law Review. 1701.
}
\concept{analyze}
