% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freeze.R
\name{freeze}
\alias{freeze}
\alias{redist.freeze}
\title{Freeze Parts of a Map}
\usage{
freeze(freeze_row, plan, .data = cur_map())

redist.freeze(adj, freeze_row, plan = rep(1, length(adj)))
}
\arguments{
\item{freeze_row}{Required, logical vector where TRUE freezes and FALSE lets
a precinct stay free or a vector of indices to freeze}

\item{plan}{A vector of district assignments, which if provided will create
separate groups by district. Recommended. In \code{freeze} defaults to the
existing plan, if one exists.}

\item{.data}{a \code{\link{redist_map}} object}

\item{adj}{Required, zero indexed adjacency list.}
}
\value{
integer vector to group by
}
\description{
Freeze Parts of a Map
}
\examples{
library(redist)
library(dplyr)
data(fl25)
data(fl25_enum)
data(fl25_adj)
plan = fl25_enum$plans[, 5118]
freeze_id <- redist.freeze(adj = fl25_adj, freeze_row = (plan == 2),
                           plan = plan)

data(iowa)
map <- redist_map(iowa, existing_plan = cd_2010, pop_tol = 0.02)
map <- map \%>\% merge_by(freeze(cd_2010 == 1, .data = .))

}
\concept{prepare}
