% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enumpart.R
\name{redist.enumpart}
\alias{redist.enumpart}
\title{Enumerate All Parititions}
\usage{
redist.enumpart(
  adj,
  unordered_path,
  ordered_path,
  out_path,
  ndists = 2,
  all = TRUE,
  n = NULL,
  weight_path = NULL,
  lower = NULL,
  upper = NULL,
  init = FALSE,
  read = TRUE,
  total_pop = NULL
)
}
\arguments{
\item{adj}{zero indexed adjacency list.}

\item{unordered_path}{valid path to output the unordered adjacency map to}

\item{ordered_path}{valid path to output the ordered adjacency map to}

\item{out_path}{Valid path to output the enumerated districts}

\item{ndists}{number of districts to enumerate}

\item{all}{boolean. TRUE outputs all districts. FALSE samples n districts.}

\item{n}{integer. Number of districts to output if all is FALSE. Returns
districts selected from uniform random distribution.}

\item{weight_path}{A path (not including ".dat") to a space-delimited file containing a vector of
vertex weights, to be used along with \code{lower} and \code{upper}.}

\item{lower}{A lower bound on each partition's total weight, implemented by rejection sampling.}

\item{upper}{An upper bound on each partition's total weight.}

\item{init}{Runs redist.init.enumpart. Defaults to false. Should be run on first use.}

\item{read}{boolean. Defaults to TRUE. reads}

\item{total_pop}{the vector of precinct populations}
}
\value{
List with entries district_membership and parity.
}
\description{
Single function for standard enumeration analysis.
}
\concept{enumerate}
