% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redistMPI.R
\name{redist.combine.mpi}
\alias{redist.combine.mpi}
\title{Combine successive runs of \code{redist.mcmc.mpi}}
\usage{
redist.combine.mpi(savename, nloop, nthin, tempadj)
}
\arguments{
\item{savename}{The name (without the loop or \code{.RData} suffix)
of the saved simulations.}

\item{nloop}{The number of loops being combined.}

\item{nthin}{How much to thin the simulations being combined.}

\item{tempadj}{The temperature adjacency object saved by
\code{redist.mcmc.mpi}.}
}
\value{
\code{redist.combine.mpi} returns an object of class "redist".
The object \code{redist} is a list that contains the folowing components (the
inclusion of some components is dependent on whether tempering
techniques are used):
\item{partitions}{Matrix of congressional district assignments generated by the
algorithm. Each row corresponds to a geographic unit, and each column
corresponds to a simulation.}
\item{distance_parity}{Vector containing the maximum distance from parity for
a particular simulated redistricting plan.}
\item{mhdecisions}{A vector specifying whether a proposed redistricting plan
was accepted (1) or rejected (0) in a given iteration.}
\item{mhprob}{A vector containing the Metropolis-Hastings acceptance
probability for each iteration of the algorithm.}
\item{pparam}{A vector containing the draw of the \code{p} parameter for each
simulation, which dictates the number of swaps attempted.}
\item{constraint_pop}{A vector containing the value of the population
constraint for each accepted redistricting plan.}
\item{constraint_compact}{A vector containing the value of the compactness
constraint for each accepted redistricting plan.}
\item{constraint_segregation}{A vector containing the value of the
segregation constraint for each accepted redistricting plan.}
\item{constraint_similar}{A vector containing the value of the similarity
constraint for each accepted redistricting plan.}
\item{beta_sequence}{A vector containing the value of beta for each iteration
of the algorithm. Returned when tempering is being used.}
\item{mhdecisions_beta}{A vector specifying whether a proposed beta value was
accepted (1) or rejected (0) in a given iteration of the algorithm. Returned
when tempering is being used.}
\item{mhprob_beta}{A vector containing the Metropolis-Hastings acceptance
probability for each iteration of the algorithm. Returned when tempering
is being used.}
}
\description{
\code{redist.combine.mpi} is used to combine successive runs of
\code{redist.mcmc.mpi} into a single data object
}
\details{
This function allows users to combine multiple successive runs of
\code{redist.mcmc.mpi} into a single \code{redist} object for analysis.
}
\examples{
\dontrun{
data(algdat.pfull)

## Code to run the simulations in Figure 4 in Fifield, Higgins, Imai and
## Tarr (2015)

## Get an initial partition
set.seed(1)
initcds <- algdat.pfull$cdmat[,sample(1:ncol(algdat.pfull$cdmat), 1)]

## Run the algorithm
redist.mcmc.mpi(adjobj = algdat.pfull$adjlist,
popvec = algdat.pfull$precinct.data$pop,
initcds = initcds,
nsims = 10000, nloops = 2, savename = "test")
out <- redist.combine.mpi(savename = "test", nloop = 2,
nthin = 10, tempadj = tempAdjMat)
}
}
\references{
Fifield, Benjamin, Michael Higgins, Kosuke Imai and Alexander Tarr.
(2016) "A New Automated Redistricting Simulator Using Markov Chain Monte
Carlo." Working Paper. Available at
\url{http://imai.princeton.edu/research/files/redist.pdf}.
}
