% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportFieldNames.R
\name{exportFieldNames}
\alias{exportFieldNames}
\alias{exportFieldNamesArgs}
\alias{exportFieldNames.redcapApiConnection}
\title{Export the Complete Field Names for a REDCap Project}
\usage{
exportFieldNames(rcon, ...)

\method{exportFieldNames}{redcapApiConnection}(
  rcon,
  fields = character(0),
  ...,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{fields}{\code{NULL} or \code{character(1)}. Field name to be returned.  By
default, all fields are returned.}

\item{...}{Arguments to pass to other methods}

\item{error_handling}{\code{character(1)}. One of \code{c("error", "null")}.
An option for how to handle errors returned by the API.
see \code{\link[=redcapError]{redcapError()}}.}

\item{config}{A named \code{list}. Additional configuration parameters to pass to
\code{\link[httr:POST]{httr::POST()}}. These are appended to any parameters in
\code{rcon$config}.}

\item{api_param}{A named \code{list}. Additional API parameters to pass into the
body of the API call. This provides users to execute calls with options
that may not otherwise be supported by \code{redcapAPI}.}
}
\value{
\code{exportFieldNames} returns a data frame with the columns:\tabular{ll}{
    \tab  \cr
   \code{original_field_name} \tab The field name as recorded in the data dictionary \cr
   \code{choice_value} \tab represents the raw coded value for a checkbox choice. For non-checkbox fields, this will always be \code{NA}. \cr
   \code{export_field_name} \tab The field name specific to the field. For non-checkbox fields, this is the same as \code{original_field_name}. For checkbox fields, it is the field name appended with \verb{___[choice_value]}. \cr
}
}
\description{
This method enables the user to access the complete field
names utilized during export and import methods. These are expecially
relevant when working with checkbox fields.
}
\details{
\code{exportFieldNames} returns a data frame of the field names the user
may use when performing export and import functions. This is most useful
when working with checkbox fields, which have a different field name than
the one used in the Meta Data. The exported/imported field names for
checkbox fields have the pattern \verb{[field_name]___[coded_checkbox_value]}
(there are exactly three underscores separating the field name and the
coded value).

Fields of types "calc", "file", and "descriptive" are not included in the
export. (Signature fields also have the "file" type and are not included)
}
\examples{
\dontrun{
unlockREDCap(connections = c(rcon = "project_alias"), 
             url = "your_redcap_url", 
             keyring = "API_KEYs", 
             envir = globalenv())

# Export all of the field names
exportFieldNames(rcon)

# Export MetaData for a specific field
exportFieldNames(rcon, 
                 fields = "checkbox_test")
}
}
\seealso{
\code{\link[=exportMetaData]{exportMetaData()}},\cr
\code{\link[=importMetaData]{importMetaData()}}, \cr
\code{\link[=exportInstruments]{exportInstruments()}},\cr
\code{\link[=exportMappings]{exportMappings()}},\cr
\code{\link[=importMappings]{importMappings()}}, \cr
\code{\link[=exportPdf]{exportPdf()}}
}
