% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deleteRecords.R
\name{deleteRecords}
\alias{deleteRecords}
\alias{deleteRecords.redcapApiConnection}
\title{Delete Records from a Project}
\usage{
deleteRecords(rcon, records, arm = NULL, ...)

\method{deleteRecords}{redcapApiConnection}(
  rcon,
  records,
  arm = NULL,
  ...,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{records}{\code{character} or \code{integerish}. Record ID's to be
returned.}

\item{arm}{\code{integerish}. the arm number of the arm in which the
record(s) should be deleted. This can only be used if the project is
longitudinal with more than one arm. If the arm parameter is not
provided, the specified records will be deleted from all arms in which
they exist. Whereas, if \code{arm} is provided, they will only be deleted from
the specified arm.}

\item{...}{Arguments to pass to other methods}

\item{error_handling}{\code{character(1)}. One of \code{c("error", "null")}.
An option for how to handle errors returned by the API.
see \code{\link[=redcapError]{redcapError()}}.}

\item{config}{A named \code{list}. Additional configuration parameters to pass to
\code{\link[httr:POST]{httr::POST()}}. These are appended to any parameters in
\code{rcon$config}.}

\item{api_param}{A named \code{list}. Additional API parameters to pass into the
body of the API call. This provides users to execute calls with options
that may not otherwise be supported by \code{redcapAPI}.}
}
\value{
\code{deleteRecords} invisibly returns a character value giving the number of records deleted.
}
\description{
These methods enable the user to delete records from a project.
}
\examples{
\dontrun{
unlockREDCap(connections = c(rcon = "project_alias"), 
             url = "your_redcap_url", 
             keyring = "API_KEYs", 
             envir = globalenv())
             
# Delete records
deleteRecords(rcon, 
              records = c("1", "2"))

}

}
\seealso{
\code{\link[=exportRecords]{exportRecords()}}, \cr
\code{\link[=importRecords]{importRecords()}}, \cr
\code{\link[=exportRecordsTyped]{exportRecordsTyped()}}
}
