% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importFileRepository.R
\name{importFileRepository}
\alias{importFileRepository}
\alias{importFileRepository.redcapApiConnection}
\title{Import a Folder and its Contents to the File Repository}
\usage{
importFileRepository(rcon, dir, folder_id = numeric(0), ...)

\method{importFileRepository}{redcapApiConnection}(
  rcon,
  dir,
  folder_id = numeric(0),
  dag_id = numeric(0),
  role_id = numeric(0),
  recursive = FALSE,
  ...,
  refresh = TRUE,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)
}
\arguments{
\item{rcon}{A redcap connection object.}

\item{dir}{\code{character(1)} A directory on the local system with the 
files to be imported to the File Repository.}

\item{folder_id}{\code{integerish(0/1)}. The ID of the folder into which 
the file is to be imported. If length is zero, it is imported to the 
top-level folder.}

\item{...}{Additional arguments to be passed between methods}

\item{dag_id}{\code{integerish(0/1)} The ID of a data access group. If 
provided, access to the folder will be restricted to the DAG.}

\item{role_id}{\code{integerish(0/1)} The ID of a role. If provided, 
access to the folder will be restricted to users with that role.}

\item{recursive}{\code{logical(1)}. If \code{FALSE}, only the files in 
the immediate directory are loaded to the File Repository. If \code{TRUE}
subfolders and their contents will also be added.}

\item{refresh}{\code{logical(1)} When \code{TRUE} (default), the cached 
File Repository data on \code{rcon} will be refreshed.}

\item{error_handling}{An option for how to handle errors returned by the API.
see \code{\link{redcap_error}}}

\item{config}{\code{list} Additional configuration parameters to pass to 
\code{\link[httr]{POST}}. These are appended to any parameters in 
\code{rcon$config}.}

\item{api_param}{\code{list} Additional API parameters to pass into the
body of the API call. This provides users to execute calls with options
that may not otherwise be supported by \code{redcapAPI}.}
}
\description{
This method allows you to import multiple files into a 
  project's File Repository. The files may be stored in a specific folder 
  in the File Repository if a \code{folder_id} is provided.
}
\author{
Benjamin Nutter
}
