% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fieldToVar.R
\name{fieldToVar}
\alias{fieldToVar}
\title{Convert a REDCap Data Field to an R Vector}
\usage{
fieldToVar(
  records,
  meta_data,
  factors = TRUE,
  dates = TRUE,
  checkboxLabels = FALSE,
  handlers = list(),
  ...
)
}
\arguments{
\item{records}{A data frame of records returned by \code{exportRecords} 
or \code{exportReports}}

\item{meta_data}{A data frame giving the data dictionary, as returned 
by \code{exportMetaData}}

\item{factors}{Logical, determines if checkbox, radio button, dropdown and yesno
variables are converted to factors}

\item{dates}{Logical, determines if date variables are converted to POSIXct format}

\item{checkboxLabels}{Logical, determines if checkbox variables are labeled as
"Checked" or using the checkbox label.  Only applicable when \code{factors = TRUE}}

\item{handlers}{List, Specify type conversion overrides for specific REDCap field types. 
E.g., \code{handlers=list(date_ = as.Date)}. For datetime specifications the
datetime ordering directive from the tail is dropped. The following field
types are supported: date_, datetime_, datetime_seconds_, time_mm_ss, time,
float,number, calc, int, integer, select, radio, dropdown, yesno, truefalse,
checkbox, and form_complete.}

\item{..., }{additional arguments that are ignored.}
}
\description{
Converts a field exported from REDCap into a valid R vector
}
\details{
This function is called internally by \code{exportRecords} and 
  \code{exportReports}.  it is not available to the user.
}
\author{
Jeffrey Horner
}
