% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/red.R
\name{thin}
\alias{thin}
\title{Spatial thinning of occurrence records.}
\usage{
thin(longlat, distance = 0.01, relative = TRUE, runs = 100)
}
\arguments{
\item{longlat}{Matrix of longitude and latitude (two columns) of species occurrence records.}

\item{distance}{Distance either in relative terms (proportion of maximum distance between any two records) or in raster units.}

\item{relative}{If TRUE, represents the proportion of maximum distance between any two records. If FALSE, is in raster units.}

\item{runs}{Number of runs}
}
\value{
A matrix of longitude and latitude (two columns) of species occurrence records separated by at least the given distance.
}
\description{
Thinning of records with minimum distances either absolute or relative to the species range.
}
\details{
Clumped distribution records due to ease of accessibility of sites, emphasis of sampling on certain areas in the past, etc. may bias species distribution models.
The algorithm used here eliminates records closer than a given threshold to any other record. The choice of records to eliminate is random, so a number of runs are made and the one keeping more of the original records is chosen.
}
\examples{
records <- matrix(sample(100), ncol = 2)
par(mfrow=c(1,2))
graphics::plot(records)
records <- thin(records, 0.1)
graphics::plot(records)
}

