% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Recordr.R
\docType{methods}
\name{listRuns}
\alias{listRuns}
\alias{listRuns,Recordr-method}
\title{List all runs recorded by record() or startRecord()}
\usage{
listRuns(recordr, ...)

\S4method{listRuns}{Recordr}(recordr, id = as.character(NA),
  script = as.character(NA), start = as.character(NA),
  end = as.character(NA), tag = as.character(NA),
  error = as.character(NA), seq = as.character(NA),
  orderBy = "-startTime", quiet = FALSE)
}
\arguments{
\item{recordr}{A Recordr instance}

\item{...}{additional parameters}

\item{id}{a \code{"character"}, the identifier to match}

\item{script}{\code{"character"},the name of the script to match}

\item{start}{\code{"character"}, Match runs that started in this time range (inclusive)
Times must be entered in the form 'YYYY-MM-DD HH:MM:SS' but can be shortened to not less that "YYYY"}

\item{end}{a \code{"character"}, Match runs that ended in this time range (inclusive)
Times must be entered in the form 'YYYY-MM-DD HH:MM:SS' but can be shortened to not less that "YYYY"}

\item{tag}{\code{"character"} Text of tag to match}

\item{error}{\code{"character"} Text of error message to match}

\item{seq}{\code{"integer"} A run sequence number (can be a range, e.g \code{seq=1:10})}

\item{orderBy}{The column that will be used to sort the output. This can include a minus sign before the name, e.g. -startTime}

\item{quiet}{A \code{logical}, if TRUE then output is not printed to the console. Default is FALSE.}
}
\value{
data frame containing information for each run
}
\description{
If no search terms are specified, then all runs are listed. The
method arguments are search terms that limit the runs listed, with anly runs listed that
match all arguments.
}
\details{
The \code{"start"} and \code{"end"} parameters can be used to specify a time
range to find runs that started execution and ended in the specified time range. For examples, specifying
\code{"start=c("2015-01-01, "2015-01-31")} will cause the search to return any execution with a starting
time in the first month of 2015.
}
\examples{
\dontrun{
rc <- new("Recordr")
# List runs that started in January 2015
listRuns(rc, start=c("2015-01-01", "2015-01-31"))
# List runs that started on or after March 1, 2014
listruns(rc, start="2014-03-01")
# List runs that contain a tag with the string "analysis v1.3")
listRuns(rc, tag="analysis v1.3")
}
}
\seealso{
\code{\link[=Recordr-class]{Recordr}}{ class description}
}

