% Generated by roxygen2 (4.0.2): do not edit by hand
\name{to_seconds}
\alias{to_seconds}
\title{to_seconds}
\usage{
to_seconds(x, format)
}
\arguments{
\item{x}{a vector of POSIXlt/POSIXct timestamps, or character strings representing a different timestamp
format.}

\item{format}{the format the timestamps take - see \code{\link{strptime}}. Does not need to be set for
POSIXlt or POSIXct timestamps.}
}
\value{
a vector of second-values, one for each timestamp.
}
\description{
converts POSIX timestamps, or character representations of other timestamp formats, to
their numeric value (represented in seconds).
}
\details{
\code{to_seconds} is designed to enable the rapid conversion of timestamps into their representation
as seconds, enabling them to be consumed by \code{\link{sessionise}}.
}
\examples{
#Converting non-POSIX timestamps to seconds
data("session_dataset")
session_dataset$timestamp <- to_seconds(x = session_dataset$timestamp, format = "\%Y\%m\%d\%H\%M\%S")

#Converting POSIX timestamps
current_time_in_seconds <- to_seconds(x = Sys.time())
}
\seealso{
\code{\link{sessionise}} for making use of the new values.
}

