% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isomap.R
\name{step_isomap}
\alias{step_isomap}
\title{Isomap embedding}
\usage{
step_isomap(
  recipe,
  ...,
  role = "predictor",
  trained = FALSE,
  num_terms = 5,
  neighbors = 50,
  options = list(.mute = c("message", "output")),
  res = NULL,
  columns = NULL,
  prefix = "Isomap",
  keep_original_cols = FALSE,
  skip = FALSE,
  id = rand_id("isomap")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the sequence of
operations for this recipe.}

\item{...}{One or more selector functions to choose variables for this step.
See \code{\link[=selections]{selections()}} for more details.}

\item{role}{For model terms created by this step, what analysis role should
they be assigned? By default, the new columns created by this step from the
original variables will be used as \emph{predictors} in a model.}

\item{trained}{A logical to indicate if the quantities for preprocessing have
been estimated.}

\item{num_terms}{The number of isomap dimensions to retain as new predictors.
If \code{num_terms} is greater than the number of columns or the number of
possible dimensions, a smaller value will be used.}

\item{neighbors}{The number of neighbors.}

\item{options}{A list of options to `dimRed::Isomap()``.}

\item{res}{The `dimRed::Isomap()`` object is stored here once this
preprocessing step has be trained by \code{\link[=prep]{prep()}}.}

\item{columns}{A character string of the selected variable names. This field
is a placeholder and will be populated once \code{\link[=prep]{prep()}} is used.}

\item{prefix}{A character string for the prefix of the resulting new
variables. See notes below.}

\item{keep_original_cols}{A logical to keep the original variables in the
output. Defaults to \code{FALSE}.}

\item{skip}{A logical. Should the step be skipped when the recipe is baked by
\code{\link[=bake]{bake()}}? While all operations are baked when \code{\link[=prep]{prep()}} is run, some
operations may not be able to be conducted on new data (e.g. processing the
outcome variable(s)). Care should be taken when using \code{skip = TRUE} as it
may affect the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_isomap()} creates a \emph{specification} of a recipe step that uses
multidimensional scaling to convert numeric data into one or more new
dimensions.
}
\details{
Isomap is a form of multidimensional scaling (MDS). MDS methods try to find a
reduced set of dimensions such that the geometric distances between the
original data points are preserved. This version of MDS uses nearest
neighbors in the data as a method for increasing the fidelity of the new
dimensions to the original data values.

This step requires the \pkg{dimRed}, \pkg{RSpectra}, \pkg{igraph}, and
\pkg{RANN} packages. If not installed, the step will stop with a note about
installing these packages.

It is advisable to center and scale the variables prior to running Isomap
(\code{step_center} and \code{step_scale} can be used for this purpose).

The argument \code{num_terms} controls the number of components that will be
retained (the original variables that are used to derive the components are
removed from the data). The new components will have names that begin with
\code{prefix} and a sequence of numbers. The variable names are padded with zeros.
For example, if \code{num_terms < 10}, their names will be \code{Isomap1} - \code{Isomap9}.
If \code{num_terms = 101}, the names would be \code{Isomap001} - \code{Isomap101}.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble is returned with
columns \code{terms}  , and \code{id}:

\describe{
\item{terms}{character, the selectors or variables selected}
\item{id}{character, id of this step}
}
}

\section{Tuning Parameters}{
This step has 2 tuning parameters:
\itemize{
\item \code{num_terms}: # Model Terms (type: integer, default: 5)
\item \code{neighbors}: # Nearest Neighbors (type: integer, default: 50)
}
}

\section{Case weights}{


The underlying operation does not allow for case weights.
}

\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(biomass, package = "modeldata")

biomass_tr <- biomass[biomass$dataset == "Training", ]
biomass_te <- biomass[biomass$dataset == "Testing", ]

rec <- recipe(
  HHV ~ carbon + hydrogen + oxygen + nitrogen + sulfur,
  data = biomass_tr
)

im_trans <- rec \%>\%
  step_YeoJohnson(all_numeric_predictors()) \%>\%
  step_normalize(all_numeric_predictors()) \%>\%
  step_isomap(all_numeric_predictors(), neighbors = 100, num_terms = 2)

im_estimates <- prep(im_trans, training = biomass_tr)

im_te <- bake(im_estimates, biomass_te)

rng <- extendrange(c(im_te$Isomap1, im_te$Isomap2))
plot(im_te$Isomap1, im_te$Isomap2,
  xlim = rng, ylim = rng
)

tidy(im_trans, number = 3)
tidy(im_estimates, number = 3)
\dontshow{\}) # examplesIf}
}
\references{
De Silva, V., and Tenenbaum, J. B. (2003). Global
versus local methods in nonlinear dimensionality reduction.
\emph{Advances in Neural Information Processing Systems}.
721-728.

\pkg{dimRed}, a framework for dimensionality reduction,
https://github.com/gdkrmr
}
\seealso{
Other multivariate transformation steps: 
\code{\link{step_classdist}()},
\code{\link{step_classdist_shrunken}()},
\code{\link{step_depth}()},
\code{\link{step_geodist}()},
\code{\link{step_ica}()},
\code{\link{step_kpca}()},
\code{\link{step_kpca_poly}()},
\code{\link{step_kpca_rbf}()},
\code{\link{step_mutate_at}()},
\code{\link{step_nnmf}()},
\code{\link{step_nnmf_sparse}()},
\code{\link{step_pca}()},
\code{\link{step_pls}()},
\code{\link{step_ratio}()},
\code{\link{step_spatialsign}()}
}
\concept{multivariate transformation steps}
