% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_median.R
\name{step_impute_median}
\alias{step_impute_median}
\alias{step_medianimpute}
\title{Impute numeric data using the median}
\usage{
step_impute_median(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  medians = NULL,
  skip = FALSE,
  id = rand_id("impute_median")
)

step_medianimpute(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  medians = NULL,
  skip = FALSE,
  id = rand_id("impute_median")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this step. See \code{\link[=selections]{selections()}} for more details.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{medians}{A named numeric vector of medians. This is \code{NULL} until
computed by \code{\link[=prep]{prep()}}. Note that, if the original data are integers,
the median will be converted to an integer to maintain the same data type.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake]{bake()}}? While all operations are baked
when \code{\link[=prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_impute_median()} creates a \emph{specification} of a recipe step that will
substitute missing values of numeric variables by the training set median of
those variables.
}
\details{
\code{step_impute_median} estimates the variable medians from the data
used in the \code{training} argument of \code{prep.recipe}. \code{bake.recipe} then applies
the new values to new data sets using these medians.

As of \code{recipes} 0.1.16, this function name changed from
\code{step_medianimpute()} to \code{step_impute_median()}.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble with
columns \code{terms} (the selectors or variables selected) and \code{model}
(themedian value) is returned.
}

\section{Case weights}{


This step performs an unsupervised operation that can utilize case weights.
As a result, case weights are only used with frequency weights. For more
information, see the documentation in \link{case_weights} and the examples on
\code{tidymodels.org}.
}

\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data("credit_data", package = "modeldata")

## missing data per column
vapply(credit_data, function(x) mean(is.na(x)), c(num = 0))

set.seed(342)
in_training <- sample(1:nrow(credit_data), 2000)

credit_tr <- credit_data[in_training, ]
credit_te <- credit_data[-in_training, ]
missing_examples <- c(14, 394, 565)

rec <- recipe(Price ~ ., data = credit_tr)

impute_rec <- rec \%>\%
  step_impute_median(Income, Assets, Debt)

imp_models <- prep(impute_rec, training = credit_tr)

imputed_te <- bake(imp_models, new_data = credit_te, everything())

credit_te[missing_examples, ]
imputed_te[missing_examples, names(credit_te)]

tidy(impute_rec, number = 1)
tidy(imp_models, number = 1)
\dontshow{\}) # examplesIf}
}
\seealso{
Other imputation steps: 
\code{\link{step_impute_bag}()},
\code{\link{step_impute_knn}()},
\code{\link{step_impute_linear}()},
\code{\link{step_impute_lower}()},
\code{\link{step_impute_mean}()},
\code{\link{step_impute_mode}()},
\code{\link{step_impute_roll}()}
}
\concept{imputation steps}
