% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constants.R, R/compound-constants.R
\docType{data}
\name{CharacterClasses}
\alias{ALNUM}
\alias{ALPHA}
\alias{ANY_CHAR}
\alias{ASCII_ALNUM}
\alias{ASCII_ALPHA}
\alias{ASCII_DIGIT}
\alias{ASCII_LOWER}
\alias{ASCII_UPPER}
\alias{BLANK}
\alias{CNTRL}
\alias{CharacterClasses}
\alias{DGT}
\alias{DIGIT}
\alias{GRAPH}
\alias{HEX_DIGIT}
\alias{LOWER}
\alias{NOT_DGT}
\alias{NOT_SPC}
\alias{NOT_WRD}
\alias{PRINT}
\alias{PUNCT}
\alias{SPACE}
\alias{SPC}
\alias{UNMATCHABLE}
\alias{UPPER}
\alias{WRD}
\title{Class Constants}
\format{An object of class \code{regex} (inherits from \code{character}) of length 1.}
\usage{
ALPHA

ALNUM

BLANK

CNTRL

DIGIT

GRAPH

LOWER

PRINT

PUNCT

SPACE

UPPER

HEX_DIGIT

ANY_CHAR

DGT

WRD

SPC

NOT_DGT

NOT_WRD

NOT_SPC

ASCII_DIGIT

ASCII_LOWER

ASCII_UPPER

ASCII_ALPHA

ASCII_ALNUM

UNMATCHABLE
}
\description{
Match a class of values.
}
\examples{
# R character classes
ALNUM
ALPHA
BLANK
CNTRL
DIGIT
GRAPH
LOWER
PRINT
PUNCT
SPACE
UPPER
HEX_DIGIT

# Generic classes
ANY_CHAR
DGT
WRD
SPC

# Generic negated classes
NOT_DGT
NOT_WRD
NOT_SPC

# Non-locale-specific classes
ASCII_DIGIT
ASCII_LOWER
ASCII_UPPER
ASCII_ALPHA
ASCII_ALNUM

# An oxymoron
UNMATCHABLE

# Usage
x <- c("a1 A", "a1 a")
rx <- LOWER \%R\% DIGIT \%R\% SPACE \%R\% UPPER
stringi::stri_detect_regex(x, rx)
}
\seealso{
\code{\link{alnum}}, \code{\link{BACKSLASH}}, \code{\link{START}}, \code{\link{BOUNDARY}}
}
\keyword{datasets}

