library(rearrr)
context("rev_windows()")

test_that("fuzz testing rev_windows()", {
  xpectr::set_test_seed(42)

  # Create a data frame
  df_length <- 12
  df <- data.frame(
    "index" = 1:df_length,
    "A" = sample(1:df_length),
    "G" = rep(c(1, 2), each = df_length/2),
    "G_index" = rep(1:(df_length/2), times = 2),
    stringsAsFactors = FALSE
  )

  # Generate expectations for 'rev_windows'
  # Tip: comment out the gxs_function() call
  # so it is easy to regenerate the tests
  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = rev_windows,
  #   args_values = list(
  #     "data" = list(df, dplyr::group_by(df, G), 1:10, -3:3, NA),
  #     "window_size" = list(3, 2, 0, 13, NA),
  #     "factor_name" = list(NULL, ".window", NA, 1),
  #     "overwrite" = list(TRUE, NA)
  #   ),
  #   extra_combinations = list(
  #     list("data" =  dplyr::group_by(df, G), "window_size" = 4),
  #     list("factor_name" = "A", "overwrite" = FALSE)
  #   ),
  #   indentation = 2
  # )


  ## Testing 'rev_windows'                                                    ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing rev_windows(data = df, window_size = 3, fact...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- rev_windows(data = df, window_size = 3, factor_name = NULL, overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["index"]],
    c(3, 2, 1, 6, 5, 4, 9, 8, 7, 12, 11, 10),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["A"]],
    c(3, 12, 11, 4, 6, 8, 10, 1, 5, 2, 9, 7),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["G"]],
    c(1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["G_index"]],
    c(3, 2, 1, 6, 5, 4, 3, 2, 1, 6, 5, 4),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("index", "A", "G", "G_index"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("integer", "integer", "numeric", "integer"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("integer", "integer", "double", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(12L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)

  # Testing rev_windows(data = dplyr::group_by(df, G), w...
  # Changed from baseline: data = dplyr::group_b...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19370 <- rev_windows(data = dplyr::group_by(df, G), window_size = 3, factor_name = NULL, overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19370),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19370[["index"]],
    c(3, 2, 1, 6, 5, 4, 9, 8, 7, 12, 11, 10),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["A"]],
    c(3, 12, 11, 4, 6, 8, 10, 1, 5, 2, 9, 7),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["G"]],
    c(1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["G_index"]],
    c(3, 2, 1, 6, 5, 4, 3, 2, 1, 6, 5, 4),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19370),
    c("index", "A", "G", "G_index"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19370),
    c("integer", "integer", "numeric", "integer"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19370),
    c("integer", "integer", "double", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19370),
    c(12L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19370)),
    character(0),
    fixed = TRUE)

  # Testing rev_windows(data = 1:10, window_size = 3, fa...
  # Changed from baseline: data = 1:10
  xpectr::set_test_seed(42)
  # Assigning output
  output_12861 <- rev_windows(data = 1:10, window_size = 3, factor_name = NULL, overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_12861),
    "integer",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_12861,
    type = "integer")
  # Testing values
  expect_equal(
    output_12861,
    c(3, 2, 1, 6, 5, 4, 9, 8, 7, 10),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_12861),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_12861),
    10L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_12861)),
    10L)

  # Testing rev_windows(data = -3:3, window_size = 3, fa...
  # Changed from baseline: data = -3:3
  xpectr::set_test_seed(42)
  # Assigning output
  output_18304 <- rev_windows(data = -3:3, window_size = 3, factor_name = NULL, overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_18304),
    "integer",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_18304,
    type = "integer")
  # Testing values
  expect_equal(
    output_18304,
    c(-1, -2, -3, 2, 1, 0, 3),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_18304),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_18304),
    7L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_18304)),
    7L)

  # Testing rev_windows(data = NA, window_size = 3, fact...
  # Changed from baseline: data = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16417 <- xpectr::capture_side_effects(rev_windows(data = NA, window_size = 3, factor_name = NULL, overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error']]),
    xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_data_frame(data): Must be of type 'data.frame', not 'logical'\n * checkmate::check_vector(data): Contains missing values (element 1)\n * checkmate::check_factor(data): Contains missing values (element 1)"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rev_windows(data = NULL, window_size = 3, fa...
  # Changed from baseline: data = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15190 <- xpectr::capture_side_effects(rev_windows(data = NULL, window_size = 3, factor_name = NULL, overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error']]),
    xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_data_frame(data): Must be of type 'data.frame', not 'NULL'\n * checkmate::check_vector(data): Must be of type 'vector', not 'NULL'\n * checkmate::check_factor(data): Must be of type 'factor', not 'NULL'"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rev_windows(data = dplyr::group_by(df, G), w...
  # Changed from baseline: data, window_size
  xpectr::set_test_seed(42)
  # Assigning output
  output_17365 <- rev_windows(data = dplyr::group_by(df, G), window_size = 4, factor_name = NULL, overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_17365),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17365[["index"]],
    c(4, 3, 2, 1, 6, 5, 10, 9, 8, 7, 12, 11),
    tolerance = 1e-4)
  expect_equal(
    output_17365[["A"]],
    c(8, 3, 12, 11, 4, 6, 7, 10, 1, 5, 2, 9),
    tolerance = 1e-4)
  expect_equal(
    output_17365[["G"]],
    c(1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2),
    tolerance = 1e-4)
  expect_equal(
    output_17365[["G_index"]],
    c(4, 3, 2, 1, 6, 5, 4, 3, 2, 1, 6, 5),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_17365),
    c("index", "A", "G", "G_index"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17365),
    c("integer", "integer", "numeric", "integer"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17365),
    c("integer", "integer", "double", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17365),
    c(12L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17365)),
    character(0),
    fixed = TRUE)

  # Testing rev_windows(data = df, window_size = 2, fact...
  # Changed from baseline: window_size = 2
  xpectr::set_test_seed(42)
  # Assigning output
  output_11346 <- rev_windows(data = df, window_size = 2, factor_name = NULL, overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_11346),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_11346[["index"]],
    c(2, 1, 4, 3, 6, 5, 8, 7, 10, 9, 12, 11),
    tolerance = 1e-4)
  expect_equal(
    output_11346[["A"]],
    c(12, 11, 8, 3, 4, 6, 1, 5, 7, 10, 2, 9),
    tolerance = 1e-4)
  expect_equal(
    output_11346[["G"]],
    c(1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2),
    tolerance = 1e-4)
  expect_equal(
    output_11346[["G_index"]],
    c(2, 1, 4, 3, 6, 5, 2, 1, 4, 3, 6, 5),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_11346),
    c("index", "A", "G", "G_index"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_11346),
    c("integer", "integer", "numeric", "integer"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_11346),
    c("integer", "integer", "double", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_11346),
    c(12L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_11346)),
    character(0),
    fixed = TRUE)

  # Testing rev_windows(data = df, window_size = 0, fact...
  # Changed from baseline: window_size = 0
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16569 <- xpectr::capture_side_effects(rev_windows(data = df, window_size = 0, factor_name = NULL, overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'window_size': Must be >= 1."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rev_windows(data = df, window_size = 13, fac...
  # Changed from baseline: window_size = 13
  xpectr::set_test_seed(42)
  # Assigning output
  output_17050 <- rev_windows(data = df, window_size = 13, factor_name = NULL, overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_17050),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17050[["index"]],
    c(12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1),
    tolerance = 1e-4)
  expect_equal(
    output_17050[["A"]],
    c(2, 9, 7, 10, 1, 5, 4, 6, 8, 3, 12, 11),
    tolerance = 1e-4)
  expect_equal(
    output_17050[["G"]],
    c(2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1),
    tolerance = 1e-4)
  expect_equal(
    output_17050[["G_index"]],
    c(6, 5, 4, 3, 2, 1, 6, 5, 4, 3, 2, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_17050),
    c("index", "A", "G", "G_index"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17050),
    c("integer", "integer", "numeric", "integer"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17050),
    c("integer", "integer", "double", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17050),
    c(12L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17050)),
    character(0),
    fixed = TRUE)

  # Testing rev_windows(data = df, window_size = NA, fac...
  # Changed from baseline: window_size = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14577 <- xpectr::capture_side_effects(rev_windows(data = df, window_size = NA, factor_name = NULL, overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14577[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'window_size': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14577[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rev_windows(data = df, window_size = NULL, f...
  # Changed from baseline: window_size = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17191 <- xpectr::capture_side_effects(rev_windows(data = df, window_size = NULL, factor_name = NULL, overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17191[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'window_size': Must be of type 'count', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17191[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rev_windows(data = df, window_size = 3, fact...
  # Changed from baseline: factor_name = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19346 <- xpectr::capture_side_effects(rev_windows(data = df, window_size = 3, factor_name = NA, overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'factor_name': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rev_windows(data = df, window_size = 3, fact...
  # Changed from baseline: factor_name = 1
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12554 <- xpectr::capture_side_effects(rev_windows(data = df, window_size = 3, factor_name = 1, overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12554[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'factor_name': Must be of type 'string' (or 'NULL'), not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12554[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rev_windows(data = df, window_size = 3, fact...
  # Changed from baseline: factor_name = ".window"
  xpectr::set_test_seed(42)
  # Assigning output
  output_14622 <- rev_windows(data = df, window_size = 3, factor_name = ".window", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_14622),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_14622[["index"]],
    c(3, 2, 1, 6, 5, 4, 9, 8, 7, 12, 11, 10),
    tolerance = 1e-4)
  expect_equal(
    output_14622[["A"]],
    c(3, 12, 11, 4, 6, 8, 10, 1, 5, 2, 9, 7),
    tolerance = 1e-4)
  expect_equal(
    output_14622[["G"]],
    c(1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2),
    tolerance = 1e-4)
  expect_equal(
    output_14622[["G_index"]],
    c(3, 2, 1, 6, 5, 4, 3, 2, 1, 6, 5, 4),
    tolerance = 1e-4)
  expect_equal(
    output_14622[[".window"]],
    c(1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_14622),
    c("index", "A", "G", "G_index", ".window"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_14622),
    c("integer", "integer", "numeric", "integer", "integer"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_14622),
    c("integer", "integer", "double", "integer", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14622),
    c(12L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_14622)),
    character(0),
    fixed = TRUE)

  # Testing rev_windows(data = df, window_size = 3, fact...
  # Changed from baseline: factor_name, overwrite
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19400 <- xpectr::capture_side_effects(rev_windows(data = df, window_size = 3, factor_name = "A", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19400[['error']]),
    xpectr::strip("1 assertions failed:\n * The column 'A' already exists and 'overwrite' is disabled."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19400[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rev_windows(data = df, window_size = 3, fact...
  # Changed from baseline: overwrite = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19782 <- xpectr::capture_side_effects(rev_windows(data = df, window_size = 3, factor_name = NULL, overwrite = NA), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'overwrite': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rev_windows(data = df, window_size = 3, fact...
  # Changed from baseline: overwrite = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11174 <- xpectr::capture_side_effects(rev_windows(data = df, window_size = 3, factor_name = NULL, overwrite = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11174[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'overwrite': Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11174[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'rev_windows'                                           ####
  #

})

test_that("testing rev_windows_vec()", {
  xpectr::set_test_seed(42)


  ## Testing 'rev_windows_vec(data = sort(runif(10)), wind...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- rev_windows_vec(data = sort(runif(10)), window_size = 3)
  # Testing class
  expect_equal(
    class(output_19148),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "double")
  # Testing values
  expect_equal(
    output_19148,
    c(0.5191, 0.28614, 0.13467, 0.70506, 0.65699, 0.64175, 0.91481,
      0.83045, 0.73659, 0.93708),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_19148),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    10L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    10L)
  ## Finished testing 'rev_windows_vec(data = sort(runif(10)), wind...'     ####


})
