% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_data.R
\name{load_clean}
\alias{load_clean}
\title{Load data then clean and format it}
\usage{
load_clean(
  import = "yes",
  file.cont = "",
  file.cat = "",
  dir = "",
  file.name = "",
  pval_cont = "no",
  match = "no",
  cohort = "no",
  anova = "no",
  dir.cont = "",
  file.name.cont = "",
  sheet.name.cont = "Sheet1",
  range.name.cont = "",
  format.cont = "wide",
  cat = "no",
  sr = "no",
  cat_all = "no",
  pval_cat = "no",
  cat.names = c("n"),
  dir.cat = "",
  file.name.cat = "",
  sheet.name.cat = "Sheet1",
  range.name.cat = "",
  format.cat = "wide",
  generic = "",
  gen.vars.keep = "",
  gen.vars.del = "",
  verbose = TRUE
)
}
\arguments{
\item{import}{'yes' indicates import excel file. 'no' indicates takes dataset already loaded into R as data frame}

\item{file.cont}{If import = 'no', name of data frame containing continuous data}

\item{file.cat}{If import = 'no', name of data frame containing categorical data}

\item{dir}{If import = 'yes', path to location of excel file for continuous and categorical data}

\item{file.name}{If import = 'yes', file name of excel file containing continuous and categorical data}

\item{pval_cont}{'yes'/'no' indicating if data will be used for pval_cont_fn. Only data for 1 continuous data function can be loaded with each run of this function.}

\item{match}{'yes'/'no' indicating if data will be used for match_fn. Only data for 1 continuous data function can be loaded with each run of this function.}

\item{cohort}{'yes'/'no' indicating if data will be used for cohort_fn. Only data for 1 continuous data function can be loaded with each run of this function.}

\item{anova}{'yes'/'no' indicating if data will be used for anova_fn. Only data for 1 continuous data function can be loaded with each run of this function.}

\item{dir.cont}{If import = 'yes', path to location of excel file for continuous data}

\item{file.name.cont}{If import = 'yes', file name of excel file containing continuous data}

\item{sheet.name.cont}{Sheet name containing continuous data}

\item{range.name.cont}{Range of cells containing continuous data. Can be in format 'a1:b20' or 'a:b'}

\item{format.cont}{'wide'/'long' indicating continuous data is in wide or long format}

\item{cat}{'yes'/'no' indicating if data will be used for cat_fn. Only data for 1 categorical data function can be loaded with each run of this function.}

\item{sr}{'yes'/'no' indicating if data will be used for sr_fn. Only data for 1 categorical data function can be loaded with each run of this function.}

\item{cat_all}{'yes'/'no' indicating if data will be used for cat_all_fn. Only data for 1 categorical data function can be loaded with each run of this function.}

\item{pval_cat}{'yes'/'no' indicating if data will be used for cat_all_fn. Only data for 1 categorical data function can be loaded with each run of this function.}

\item{cat.names}{names of variables to be used in cat_fn and sr_fn}

\item{dir.cat}{If import = 'yes', path to location of excel file for categorical data}

\item{file.name.cat}{If import = 'yes', file name of excel file containing categorical data}

\item{sheet.name.cat}{Sheet name containing categorical data}

\item{range.name.cat}{Range of cells containing categorical. Can be in format 'a1:b20' or 'a:b'}

\item{format.cat}{'wide'/'long' indicating categorical data is in wide or long format}

\item{generic}{'yes'/'no' indicating if data to be loaded for generic use}

\item{gen.vars.keep}{Vector of variables in data to keep}

\item{gen.vars.del}{Vector of variables in data to delete}

\item{verbose}{TRUE/FALSE TRUE indicates comments will be printed during loading}
}
\value{
list containing a named data frame containing data in suitable format for appropriate function as described in Details
}
\description{
Function loads and cleans data for the nine functions
}
\details{
Function can load continuous or categorical data.
Continuous data can be used for comparison of baseline p-values (pval_cont_fn),
matching summary stats within a trial (match_fn), matching summary stats in different cohorts (cohort_fn),
or comparing means of baseline p-values (anova_fn).
Categorical data can be used for comparisons of observed with expected distributions for single variable (cat_fn),
for group numbers in trials using simple randomisation (sr_fn), for all variables (cat_all_fn), and for comparison
of baseline p-values (pval_cat_fn).\cr

There is one function in development that allows assessment of proportion of final digits in summary statistics (final_digit_fn).
This function works using summary statistics but could be adapted to use on raw continuous or categorical data.

Only 1 continuous and/or 1 categorical data set allowed per load to avoid clashes

Data can be imported from a file (import = "yes") or taken from an existing data frame, import = "no"

If loading from an existing data use file.cont and file.cat

If loading from common directory or file, can use dir and file.name rather than more specific dir.cont, dir.cat,
file.name.cont, or file.name.cat.

\strong{Comments about each indicator:}
\emph{pval_cont}\cr
loads continuous data for pval_cont_fn, outputs as list of 1 containing named data frame pval_cont_data.\cr

format should be study, variable or var, n, m, s, p. Can be in any order. n = sample size, m = mean, s = standard deviation,
p = baseline p value (can omit if not reported)\cr

can be in wide or long format\cr
wide: study, var, n1, n2, n3 ..., m1, m2, m3 ... s1, s2, s3..., p\cr
long: study, var, group, m , s,  n , p\cr

group or g or grp required for long format\cr
separators (eg n1 n_1 n.1) are stripped and replaced\cr

\emph{match}\cr
loads continuous data for match_fn, outputs as list of 1 containing named data frame match_data\cr

remainder is same as for pval_cont above.\cr
only difference between pval_cont and match is that match allows for missing mean or SD whereas pval_cont does not\cr

format should be study, variable or var, n, m, s. Can be in any order. n = sample size, m = mean, s = standard deviation\cr

can be in wide or long format\cr
wide: study, var, n1, n2, m1, m2, s1, s2, p\cr
long: study, var, group, m , s,  n \cr

group or g or grp required for long format\cr
separators (eg n1 n_1 n.1) are stripped and replaced\cr

\emph{cohort}\cr
loads continuous data for cohort_fn, outputs as list of 1 containing named data frame cohort_data\cr

same as pval_cont but allows a lookup variable for variable names\cr

format should be study, variable or var, n, m, s, p. Can be in any order. n = sample size, m = mean, s = standard deviation\cr

can be in wide or long format\cr
wide: study, var, n1, n2, n3 ..., m1, m2, m3 ... s1, s2, s3... \cr
long: study, var, group, m , s,  n \cr

group or g or grp required for long format\cr
separators (eg n1 n_1 n.1) are stripped and replaced\cr

lookup table is var_name_final, var_name_orig and allows you to specify a list of all variables names (var_name_orig)
from all studies and a lookup table of standardised names (var_name_final) allowing different names in different studies to
be standardised\cr

has optional variable 'population' which can be used to subset the data if trials in different populations are reported\cr

\emph{anova}\cr
loads continuous data for anova_fn, outputs as list of 1 containing named data frame anova_data\cr

same as for pval_cont above but allows for optional value for decimal place\cr

format should be study, variable or var, n, m, s, p. Can be in any order. n = sample size, m = mean, s = standard deviation,
d= decimal place of mean (if omitted, this is calculated automatically in anova_fn)\cr

can be in wide or long format\cr
wide: study, var, n1, n2, n3 ..., m1, m2, m3 ... s1, s2, s3..., d\cr
long: study, var, group, m , s,  n , d\cr

group or g or grp required for long format\cr
separators (eg n1 n_1 n.1) are stripped and replaced\cr

\emph{cat}\cr
loads categorical data for cat_fn, outputs as list of 1 containing named data frame cat_data\cr

format should be study, n, v. Can be in any order, n= group size, v= number with characteristic\cr

can be in wide or long format\cr
wide: study, n1, n2, n3 ..., v1, v2, v3...\cr
long: study, group, n, v\cr

group or g or grp required for long format\cr
use cat.names to name variable eg c("n", "v") , c("n", "g") ...\cr
separators (eg n1 n_1 n.1) are stripped and replaced\cr

\emph{sr}\cr
loads categorial data for sr_fn, outputs as list of 1 containing named data frame sr_data\cr

as for cat but only requires study and n

format should be study, n. n= group size\cr

can be in wide or long format\cr
wide: study, n1, n2, n3 ...\cr
long: study, group, n\cr

group or g or grp required for long format\cr
separators (eg n1 n_1 n.1) are stripped and replaced\cr

\emph{cat_all}\cr
loads categorical data for cat_all_fn, outputs as list of 1 containing named data frame cat_all_data\cr

format should be study, var or variable, n, N, level, stat, recode, p. Can be in any order, n = number with characteristic, N = group size,
p = baseline p value (can omit if not reported), can use "ns" for not significant or "<" or ">" to indicate threshold (eg "<0.05") \cr

optional level - number for level of variable (eg y/n =1,2; high/med/low =1,2,3)\cr
optional recode- for variables with >2 levels to tell how to recode into 2 groups\cr
optional stat: statistical test used for p-value : chisq - Chisquare, chisqc- Chisquare with correction,
fisher- Fisher's exact, midp - midp -calculated using two different methods, lr- likelihood ratio,
mh - Mantel-Haenszel test\cr

can be in wide or long format\cr
wide study, var, n1, n2, n3, ... N1, N2, N3... p, stat, level, recode\cr
long study, var, group, n, N, p, stat, level, recode\cr

group or g or grp required for long format\cr

if variable has 2 levels, only 1 required, other will be calculated.\cr

separators (eg n1 n_1 n.1) are stripped and replaced\cr

\emph{pval_cat}\cr
loads categorical data for pval_cat_fn, outputs as list of 1 containing named data frame pval_cat_data\cr

as for cat_all but recode variable is not generated

format should be study, var or variable, n, N, p. Can be in any order, n = number with characteristic, N = group size,
p = baseline p value (can omit if not reported), can use "ns" for not significant or "<" or ">" to indicate threshold (eg "<0.05") \cr

optional level - number for level of variable (eg y/n =1,2; high/med/low =1,2,3)\cr
optional stat: statistical test used for p-value : chisq - Chisquare, fisher- Fisher's exact\cr

can be in wide or long format\cr
wide study, var, n1, n2, n3, ... N1, N2, N3... p, stat, level\cr
long study, var, group, n, N, p, stat, level\cr

group or g or grp required for long format\cr

if variable has 2 levels, only 1 required, other will be calculated.\cr

separators (eg n1 n_1 n.1) are stripped and replaced\cr

\emph{generic}\cr
loads data for use generic use, outputs as list of 1 containing named data frame generic_data\cr

use cont suffixes for file details: dir.cont (or dir), file.name.cont (or file.name), sheet.name,cont, range.name.cont)\cr

format should be study, var or variable, variable names\cr

optional gen.vars.keep = vector of variables to keep\cr
optional gen.vars.del = vector of variables to delete

can be in wide or long format\cr
wide study, var, a1, a2..., b1, b2 ... \cr
long study, var, group, a, b, ....\cr

group or g or grp required for long format\cr

separators (eg n1 n_1 n.1) are stripped and replaced\cr
no data checking or other transformations take place\cr
}
\examples{
# examples of loading data for each function are given in the individual functions.
# Here is one- for pval_cont_fn():

pval_cont_data <- load_clean(import= "no", file.cont = "SI_pvals_cont", pval_cont= "yes",
format.cont = "wide")$pval_cont_data

\donttest{
# to import an excel spreadsheet (modify using local path,
# file and sheet name, range, and format):

# get path for example files
path <- system.file("extdata", "reappraised_examples.xlsx", package = "reappraised",
                    mustWork = TRUE)
# delete file name from path
path <- sub("/[^/]+$", "", path)

# load data
pval_cont_data <- load_clean(import= "yes", pval_cont = "yes", dir = path,
     file.name.cont = "reappraised_examples.xlsx", sheet.name.cont = "SI_pvals_cont",
     range.name.cont = "A1:O51", format.cont = "wide")$pval_cont_data}

}
