% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat_all.R
\name{cat_all_fn}
\alias{cat_all_fn}
\title{Compares observed and expected distribution of all categorical (binomial) variables}
\usage{
cat_all_fn(
  df = cat_all_data,
  comp.pvals = "no",
  binom = "no",
  two_levels = "no",
  del.disparate = "yes",
  excl.level = "yes",
  seed = 0,
  title = "",
  verbose = TRUE
)
}
\arguments{
\item{df}{data frame generated from load_clean function}

\item{comp.pvals}{"yes" or "no" indicator whether reported and calculated p-values should be compared}

\item{binom}{"yes" or "no" indicator whether observed to expected distributions of binomial variables should be calculated}

\item{two_levels}{"yes" or "no" indicator whether variables with more than 2 levels should be collapsed to 2 levels}

\item{del.disparate}{if yes, data in which the absolute difference between group sizes is >20\% are deleted}

\item{excl.level}{"yes" or "no" indicator whether one level of a variable should be deleted. Deleted level is chosen randomly using seed parameter.}

\item{seed}{seed for random number generator, default 0 = current date and time. Specify seed to make repeatable.}

\item{title}{title name for plots (optional)}

\item{verbose}{TRUE or FALSE indicates whether progress bar and comments show and flextable or plot or both are printed}
}
\value{
list containing objects as described\cr

if p-value comparison used:
\itemize{
\item cat_all_pvals = data frame of data for comparison of reported and calculated p-values
\item cat_all_diff_calc_rep_ft = flextable of comparison of reported and calculated p-values
\item cat_all_diff_calc_rep_data = data frame used to make flextable
\item cat_all_diff_thresh_ft = flextable of comparison of reported and calculated p-values when only threshold given
\item cat_all_diff_thresh_data = data frame used to make flextable for p-value thresholds
}

if comparing categorical variables used
\itemize{
\item cat_all_graph = plot of observed to expected numbers and differences between groups, top panels are the absolute numbers, bottom panels are the differences between trial arms in two arm studies
\item cat_all_graph_pc = plot of observed to expected numbers expressed as percentages and differences between groups, top panels are the percentages, bottom panels are the differences between trial arms in two arm studies
\item cat_all_data_abs = data frame of data for absolute numbers
\item cat_all_data_df = data frame of data for difference between groups in two arm studies
\item cat_all_dataset_abs = data frame of dataset used for all trials
\item cat_all_dataset_df = data frame of dataset used for two arm trials
\item cat_all_all_graphs list containing
\itemize{
\item abs = plot for absolute numbers only
\item df = plot for difference between groups in two arm studies only
\item pc = plot for percentages only
\item all_pc = composite plot of percentages and absolute numbers
\item individual_graphs list of 6 individual plots making up composite figures
}
}
}
\description{
Creates plots of observed to expected numbers and ratios for the binomial variables and/or compares reported and calculated p-values for the variables\cr
Reference: Bolland MJ, Gamble GD, Avenell A, Cooper DJ, Grey A. Distributions of baseline categorical variables were different from the expected distributions in randomized trials with integrity concerns. J Clin Epidemiol. 2023;154:117-124
}
\details{
Returns a list containing objects described below and (if verbose = TRUE) prints the flextable cat_all_diff_calc_rep_ft and/or graph cat_all_graph depending on options chosen
}
\examples{
# load example data
cat_all_data <- load_clean(import= "no", file.cat = "SI_cat_all", cat_all= "yes",
format.cat = "wide")$cat_all_data

\donttest{
# run function comparing p-values only (takes only a few seconds)
cat_all_fn (comp.pvals = "yes")$cat_all_diff_calc_rep_ft

# run function comparing distribution of binomial variables only

# to speed example up limit to 12 2-arm trials with 20 variables
# (takes close to 5 secs)

cat_all_data <- cat_all_data [1:41, c(1:8,10:11,13:15)]

cat_all_fn (binom = "yes", two_levels = "yes", del.disparate = "yes",
excl.level = "yes", seed = 10)$cat_all_graph


# to import an excel spreadsheet (modify using local path,
# file and sheet name, range, and format):

# get path for example files
path <- system.file("extdata", "reappraised_examples.xlsx", package = "reappraised",
                   mustWork = TRUE)
# delete file name from path
path <- sub("/[^/]+$", "", path)

# load data
cat_all_data <- load_clean(import= "yes", cat_all = "yes", dir = path,
   file.name.cat = "reappraised_examples.xlsx", sheet.name.cat = "SI_cat_all",
   range.name.cat = "A:N", format.cat = "wide")$cat_all_data}

}
