% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RTM.R
\name{dRTM_grid}
\alias{dRTM_grid}
\title{Generate Grid for PDF of the Rational Threshold Model}
\usage{
dRTM_grid(rt_max = 10, phi, x_res = "default", t_res = "default")
}
\arguments{
\item{rt_max}{maximal response time <- max(rt)}

\item{phi}{parameter vector in the following order:
\enumerate{
\item Non-decision time (\eqn{t_{nd}}). Time for non-decision processes such as stimulus
encoding and response execution. Total decision time t is the sum of the decision
and non-decision times.
\item Relative start (\eqn{w}). Sets the start point of accumulation as a ratio of
the two decision thresholds. Related to the absolute start z point via equation
\eqn{z = b_l + w*(b_u - b_l)}.
\item Stimulus strength (\eqn{\mu}). Strength of the stimulus and used to set the drift
rate. For changing threshold models \eqn{v(x,t) = \mu}.
\item Noise scale (\eqn{\sigma}). Model noise scale parameter.
\item Initial decision threshold location (\eqn{b_0}). Sets the location of each decision
threshold at time \eqn{t = 0}.
\item Amount of decision threshold collapse (\eqn{\kappa}).
\item Semi-saturation constant (\eqn{t_{0.5}}). The semi-saturation constant is the value of
time at which the boundaries have collapsed by half \eqn{\kappa}.
\item Contamination (\eqn{g}). Sets the strength of the contamination process. Contamination
process is a uniform distribution \eqn{f_c(t)} where \eqn{f_c(t) = 1/(g_u-g_l)}
if \eqn{g_l <= t <= g_u} and \eqn{f_c(t) = 0} if \eqn{t < g_l} or \eqn{t > g_u}. It is
combined with PDF \eqn{f_i(t)} to give the final combined distribution
\eqn{f_{i,c}(t) = g*f_c(t) + (1-g)*f_i(t)}, which is then output by the program.
If \eqn{g = 0}, it just outputs \eqn{f_i(t)}.
\item Lower bound of contamination distribution (\eqn{g_l}). See parameter \eqn{g}.
\item Upper bound of contamination distribution (\eqn{g_u}). See parameter \eqn{g}.
}}

\item{x_res}{spatial/evidence resolution}

\item{t_res}{time resolution}
}
\value{
list of RTs and corresponding defective PDFs at lower and upper threshold
}
\description{
Generate a grid of response-time values and the corresponding PDF values.
For more details on the model see, for example, \code{\link{dRTM}}.
}
\references{
Churchland, A. K., Kiani, R., & Shadlen, M. N. (2008). Decision-making with multiple
alternatives. \emph{Nature Neuroscience, 11}(6), 693-702.

Hanks, T. D., Mazurek, M. E., Kiani, R., Hopp, E., & Shadlen, M. N. (2011). Elapsed
Decision Time Affects the Weighting of Prior Probability in a Perceptual Decision
Task. \emph{The Journal of Neuroscience, 31}(17), 6339-6352.

Voskuilen, C., Ratcliff, R., & Smith, P. L. (2016). Comparing fixed and collapsing boundary
versions of the diffusion model. \emph{Journal of Mathematical Psychology, 73}, 59-79.
}
\author{
Raphael Hartmann & Matthew Murrow
}
