% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_data_cube.r
\name{read_lfs_datacube}
\alias{read_lfs_datacube}
\title{Convenience function to download and tidy data cubes from
ABS Labour Force, Australia, Detailed.}
\usage{
read_lfs_datacube(cube, path = Sys.getenv("R_READABS_PATH", unset = tempdir()))
}
\arguments{
\item{cube}{character. A character string that is either the complete filename
or (uniquely) in the filename of the data cube you want to download. Use
\code{get_available_lfs_cubes()} to see a dataframe of options.}

\item{path}{Local directory in which downloaded files should be stored.}
}
\value{
A tibble with the data from the data cube. Columns names are
tidied and dates are converted to Date class.
}
\description{
Convenience function to download and tidy data cubes from
ABS Labour Force, Australia, Detailed.
}
\examples{
read_lfs_datacube("EQ02")
}
