% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_download.R
\name{drop_get}
\alias{drop_get}
\title{Downloads a file from Dropbox}
\usage{
drop_get(
  path = NULL,
  local_file = NULL,
  overwrite = FALSE,
  verbose = FALSE,
  progress = FALSE,
  dtoken = get_dropbox_token()
)
}
\arguments{
\item{path}{Path in the user's Dropbox, relative to root}

\item{local_file}{The name of the local copy. Leave this blank if you're fine with the original name.}

\item{overwrite}{Default is \code{FALSE} but can be set to \code{TRUE}.}

\item{verbose}{By default verbose output is \code{FALSE}. Set to \code{TRUE}
if you need to troubleshoot any output or grab additional parameters.}

\item{progress}{Progress bars are turned off by default. Set to \code{TRUE} ot turn this on. Progress is only reported when file sizes are known. Otherwise just bytes downloaded.}

\item{dtoken}{The Dropbox token generated by \code{\link{drop_auth}}. rdrop2
will try to automatically locate your local credential cache and use them.
However, if the credentials are not found, the function will initiate a new
authentication request. You can override this in \code{\link{drop_auth}} by
pointing to a different location where your credentials are stored.}
}
\description{
Downloads a file from Dropbox
}
\examples{
\dontrun{
  drop_get(path = 'dataset.zip', local_file = "~/Desktop")
  # To overwrite the existing file
  drop_get(path = 'dataset.zip', overwrite = TRUE)
}

}
