# rdflib 0.2.1

* Minor patch to make test compatible with breaking change in readr 1.2.0 (#30)

# rdflib 0.2.0 2018-11-13

## New Features

* `rdf()` supports all major storage backends: Virtuoso, SQLite, Postgres, MySQL,
   in addition to existing support for BDB and memory-based storage.
* `length()` method added to report length of triplestore
* `print()` method gains `rdf_max_print()` option and does not print huge triplestores
* `print()` method sumarizes total number of triples and backend

# rdflib 0.1.0 (2018-03-02)

## New Features

* `rdf()` supports BDB backend for disk-based storage for large
   triplestores [#6](https://github.com/cboettig/rdflib/issues/6)
* `rdf_parse()` gains an argument `rdf` to append triples to existing graph
* adds `c()` method to concatenate `rdf` objects
* Performance improvements make it possible to handle triplestores with millions of triples
* Two new vignettes better introduce RDF and package functions.

## Minor Improvements

* `rdf_query` now bypasses the the very slow iteration over `getNextResult`
   approach and uses an internal redland function call to access all results
   at once in csv format.
* experimental `as_rdf` method now uses a poor-man's nquad serializer to
  rapidly generate rdf (instead of slowly iterating over `add_rdf`).  

* `rdf_add` argument for `object` can now take all atomic types
   (numeric, integer, string, Date, POSIX, logical) and 
   will automatically declare the appropriate `datatype_uri`
   if the user has not manually specified this. 
* Numerous improvements to documentation from rOpenSci onboarding feedback, see 
  [#9](https://github.com/cboettig/rdflib/issues/9) and 
  [#10](https://github.com/cboettig/rdflib/issues/10) 
* both functions and unit tests are broken out into separate files in
  their respective directories.
* additional example RDF data added in `extdata`
* `rdf_serialize` passes `...` arguments to serializeToFile (e.g. to set a `baseUri`) 

## Bug Fixes 

* `rdf_free()` will also remove the object from the parent frame, 
  reducing the potential for crashing R by referring to a freed pointer.
* fix encoding with UTF-8 characters (coming from nquads & ntriples)
* `rdf_query()` now coerces data into appropriate type 
   if it recognizes the data URI and can match that 
   to an R type (a few XMLSchema types are recognized,
   otherwise still defaults to character string)
* Memory management: All methods free memory from any 
  temporary objects they initialize, tests free memory.
  (e.g. parsers, serializers, query, statement)
* extend unit tests to cover new features, check UTF-8
* `turtle` parser/serializer fixed

## Deprecated

* `trig` support removed (not working in redland without optional
   libraries and alternative compile configuration)


# rdflib 0.0.3 (2018-01-02)

## Bug Fixes

* add paper.md
* add package level documentation
* set base uri when serializing json-ld to rdf ([#5](https://github.com/cboettig/rdflib/issues/5))


# rdflib 0.0.2 (2018-01-02)

## New Features

* Added a `NEWS.md` file to track changes to the package.
* sparql query returns a data.frame format
* added a vignette
* added pkgdown website for vignette

# rdflib 0.0.1 (2017-12-09)

* Initial prototype


