% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiracDistribution.R
\docType{class}
\name{DiracDistribution}
\alias{DiracDistribution}
\title{A Dirac delta function}
\description{
An R6 class representing a Dirac Delta function.
}
\details{
A distribution modelled by a Dirac delta function \eqn{\delta(x-c)}
where \eqn{c} is the hyperparameter (value of the constant). It has 
probability 1 that the value will be equal to \eqn{c} and zero otherwise. 
The mode, mean, quantiles and random samples are all equal to \eqn{c}. It is
acknowledged that there is debate over whether Dirac delta functions are 
true distributions, but the assumption makes little practical difference in 
this case. Inherits from class \code{Distribution}.
}
\author{
Andrew Sims \email{andrew.sims@newcastle.ac.uk}
}
\section{Super class}{
\code{\link[rdecision:Distribution]{rdecision::Distribution}} -> \code{DiracDistributon}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DiracDistributon-new}{\code{DiracDistribution$new()}}
\item \href{#method-DiracDistributon-distribution}{\code{DiracDistribution$distribution()}}
\item \href{#method-DiracDistributon-mode}{\code{DiracDistribution$mode()}}
\item \href{#method-DiracDistributon-mean}{\code{DiracDistribution$mean()}}
\item \href{#method-DiracDistributon-SD}{\code{DiracDistribution$SD()}}
\item \href{#method-DiracDistributon-quantile}{\code{DiracDistribution$quantile()}}
\item \href{#method-DiracDistributon-sample}{\code{DiracDistribution$sample()}}
\item \href{#method-DiracDistributon-clone}{\code{DiracDistribution$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="Distribution" data-id="order"><a href='../../rdecision/html/Distribution.html#method-Distribution-order'><code>rdecision::Distribution$order()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="Distribution" data-id="r"><a href='../../rdecision/html/Distribution.html#method-Distribution-r'><code>rdecision::Distribution$r()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="Distribution" data-id="varcov"><a href='../../rdecision/html/Distribution.html#method-Distribution-varcov'><code>rdecision::Distribution$varcov()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DiracDistributon-new"></a>}}
\if{latex}{\out{\hypertarget{method-DiracDistributon-new}{}}}
\subsection{Method \code{new()}}{
Create a new Dirac Delta function distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DiracDistribution$new(const)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{const}}{The value at which the distribution is centred.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{DiracDistribution} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DiracDistributon-distribution"></a>}}
\if{latex}{\out{\hypertarget{method-DiracDistributon-distribution}{}}}
\subsection{Method \code{distribution()}}{
Accessor function for the name of the distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DiracDistribution$distribution()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Distribution name as character string.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DiracDistributon-mode"></a>}}
\if{latex}{\out{\hypertarget{method-DiracDistributon-mode}{}}}
\subsection{Method \code{mode()}}{
Return the mode of the distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DiracDistribution$mode()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Numeric Value where the distribution is centred.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DiracDistributon-mean"></a>}}
\if{latex}{\out{\hypertarget{method-DiracDistributon-mean}{}}}
\subsection{Method \code{mean()}}{
Return the expected value of the distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DiracDistribution$mean()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Expected value as a numeric value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DiracDistributon-SD"></a>}}
\if{latex}{\out{\hypertarget{method-DiracDistributon-SD}{}}}
\subsection{Method \code{SD()}}{
Return the standard deviation of the distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DiracDistribution$SD()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Standard deviation as a numeric value
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DiracDistributon-quantile"></a>}}
\if{latex}{\out{\hypertarget{method-DiracDistributon-quantile}{}}}
\subsection{Method \code{quantile()}}{
Quantiles of the distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DiracDistribution$quantile(probs)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{probs}}{Numeric vector of probabilities, each in range [0,1].}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
For a Dirac Delta Function all quantiles are returned as the
value at which the distribution is centred.
}

\subsection{Returns}{
Vector of numeric values of the same length as \code{probs}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DiracDistributon-sample"></a>}}
\if{latex}{\out{\hypertarget{method-DiracDistributon-sample}{}}}
\subsection{Method \code{sample()}}{
Draw and hold a random sample from the model variable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DiracDistribution$sample(expected = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{expected}}{If TRUE, sets the next value retrieved by a call to
\code{r()} to be the mean of the distribution.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Updated distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DiracDistributon-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DiracDistributon-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DiracDistribution$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
